/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.datagen;

import java.util.Set;
import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.registries.ModContent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class ImpatientBlockLootTableProvider
extends BlockLootSubProvider {
    protected ImpatientBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.addBlockDropSelf("impatient");
        this.addBlockDropSelf("compressed_impatient");
        this.addBlockDropSelf("double_compressed_impatient");
    }

    private void addBlockDropSelf(String blockName) {
        ResourceLocation blockId = ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)blockName);
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
        if (block != null) {
            this.dropSelf(block);
        } else {
            ImpatientMod.LOGGER.warn("Block not found to add: " + blockName);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModContent.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }
}

