/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ImpatientRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    Block impatientTorch = this.getBlock("impatient");
    Block compressedImpatientTorch = this.getBlock("compressed_impatient");
    Block doubleCompressedImpatientTorch = this.getBlock("double_compressed_impatient");

    public ImpatientRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.impatientTorch).pattern(" C ").pattern("CTC").pattern(" C ").define(Character.valueOf('C'), (ItemLike)Items.CLOCK).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)Items.CLOCK), ImpatientRecipeProvider.has((ItemLike)Items.CLOCK)).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)Items.TORCH), ImpatientRecipeProvider.has((ItemLike)Items.TORCH)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.compressedImpatientTorch).pattern("III").pattern("III").pattern("III").define(Character.valueOf('I'), (ItemLike)this.getBlock("impatient")).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)this.getBlock("impatient")), ImpatientRecipeProvider.has((ItemLike)this.getBlock("impatient"))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.doubleCompressedImpatientTorch).pattern("CCC").pattern("CCC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)this.getBlock("compressed_impatient")).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)this.getBlock("compressed_impatient")), ImpatientRecipeProvider.has((ItemLike)this.getBlock("compressed_impatient"))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.impatientTorch, (int)9).requires((ItemLike)this.getBlock("compressed_impatient")).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)this.compressedImpatientTorch), ImpatientRecipeProvider.has((ItemLike)this.compressedImpatientTorch)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"from_compressed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.compressedImpatientTorch, (int)9).requires((ItemLike)this.getBlock("double_compressed_impatient")).unlockedBy(ImpatientRecipeProvider.getHasName((ItemLike)this.doubleCompressedImpatientTorch), ImpatientRecipeProvider.has((ItemLike)this.doubleCompressedImpatientTorch)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"from_double_compressed"));
    }

    private Block getBlock(String blockName) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(this.getBlockId(blockName));
        if (block != null) {
            return block;
        }
        LOGGER.warn("Block not found to add: " + blockName);
        return null;
    }

    private ResourceLocation getBlockId(String blockName) {
        return ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)blockName);
    }
}

