/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.biorfn.impatient.block.entity.ImpatientBlockEntity;
import net.biorfn.impatient.client.screen.ImpatientScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OpenScreenMessage {
    private BlockPos pos;
    private Component title;
    private int xRange;
    private int zRange;
    private int yRange;
    private int speed;
    private int redstoneMode;
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"open-screen-message");
    public static final StreamCodec<FriendlyByteBuf, OpenScreenMessage> STREAM_CODEC = StreamCodec.ofMember(OpenScreenMessage::encode, OpenScreenMessage::decode);

    public OpenScreenMessage(BlockPos pos, Component title, int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        this.pos = pos;
        this.title = title;
        this.xRange = xRange;
        this.zRange = zRange;
        this.yRange = yRange;
        this.speed = speed;
        this.redstoneMode = redstoneMode;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(OpenScreenMessage message, FriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos).writeJsonWithCodec(ComponentSerialization.CODEC, (Object)message.title);
        buf.writeInt(message.xRange).writeInt(message.zRange).writeInt(message.yRange).writeInt(message.speed).writeInt(message.redstoneMode);
    }

    public static OpenScreenMessage decode(FriendlyByteBuf buf) {
        return new OpenScreenMessage(buf.readBlockPos(), (Component)buf.readJsonWithCodec(ComponentSerialization.CODEC), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(PacketContext<OpenScreenMessage> ctx) {
        if (ctx.side().opposite() == Side.SERVER) {
            OpenScreenMessage.openImpatientScreen((OpenScreenMessage)ctx.message());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openImpatientScreen(OpenScreenMessage message) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.submitAsync(() -> {
            BlockEntity patt0$temp = minecraft.player.level().getBlockEntity(message.pos);
            if (patt0$temp instanceof ImpatientBlockEntity) {
                ImpatientBlockEntity blockEntity = (ImpatientBlockEntity)patt0$temp;
                ImpatientScreen screen = new ImpatientScreen(message.title, message.xRange, message.zRange, message.yRange, message.speed, message.redstoneMode, blockEntity.getBlockPos(), blockEntity.getTier());
                minecraft.setScreen((Screen)screen);
            }
        });
    }
}

