/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.network;

import com.mojang.datafixers.util.Pair;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.HashMap;
import java.util.Map;
import net.biorfn.impatient.ImpatientImpl;
import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.api.Tier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class S2CTierSyncMessage {
    private final Map<ResourceLocation, Tier> tiers;
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"s2c-tier-sync-message");
    public static final StreamCodec<FriendlyByteBuf, S2CTierSyncMessage> STREAM_CODEC = StreamCodec.ofMember(S2CTierSyncMessage::encode, S2CTierSyncMessage::decode);

    public S2CTierSyncMessage(Map<ResourceLocation, Tier> tiers) {
        this.tiers = tiers;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(S2CTierSyncMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.tiers.size());
        message.tiers.forEach((name, tier) -> S2CTierSyncMessage.writeTier(name, tier, buf));
    }

    public static S2CTierSyncMessage decode(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, Tier> localTiers = new HashMap<ResourceLocation, Tier>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            Pair<ResourceLocation, Tier> entry = S2CTierSyncMessage.readTier(buf);
            localTiers.put((ResourceLocation)entry.getFirst(), (Tier)entry.getSecond());
        }
        return new S2CTierSyncMessage(localTiers);
    }

    public static void handle(PacketContext<S2CTierSyncMessage> ctx) {
        if (ctx.side() == Side.SERVER) {
            S2CTierSyncMessage.handleServerSide(ctx);
        } else if (ctx.side() == Side.CLIENT) {
            S2CTierSyncMessage.handleClientSide(ctx);
        }
    }

    private static void handleServerSide(PacketContext<S2CTierSyncMessage> ctx) {
        MinecraftServer server;
        ServerPlayer player = ctx.sender();
        if (player != null && (server = player.getServer()) != null) {
            server.execute(() -> {
                try {
                    ((ImpatientImpl)ImpatientAPI.INSTANCE).setRemoteTiers(((S2CTierSyncMessage)ctx.message()).tiers);
                }
                catch (Exception e) {
                    ImpatientMod.LOGGER.error("Error updating remote tiers", (Throwable)e);
                }
            });
        }
    }

    private static void handleClientSide(PacketContext<S2CTierSyncMessage> ctx) {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            client.execute(() -> {
                try {
                    ((ImpatientImpl)ImpatientAPI.INSTANCE).setRemoteTiers(((S2CTierSyncMessage)ctx.message()).tiers);
                }
                catch (Exception e) {
                    ImpatientMod.LOGGER.error("Error updating remote tiers", (Throwable)e);
                }
            });
        }
    }

    private static Pair<ResourceLocation, Tier> readTier(FriendlyByteBuf buffer) {
        return new Pair((Object)buffer.readResourceLocation(), (Object)new Tier(buffer.readInt(), buffer.readInt(), buffer.readInt()));
    }

    private static void writeTier(ResourceLocation name, Tier tier, FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(name).writeInt(tier.maxSpeed()).writeInt(tier.xzRange()).writeInt(tier.yRange());
    }
}

