/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.block.entity.ImpatientBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ValueUpdateMessage {
    private BlockPos pos;
    private int xRange;
    private int zRange;
    private int yRange;
    private int speed;
    private int redstoneMode;
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"value-update-message");
    public static final StreamCodec<FriendlyByteBuf, ValueUpdateMessage> STREAM_CODEC = StreamCodec.ofMember(ValueUpdateMessage::encode, ValueUpdateMessage::decode);

    public ValueUpdateMessage(BlockPos pos, int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        this.pos = pos;
        this.xRange = xRange;
        this.zRange = zRange;
        this.yRange = yRange;
        this.speed = speed;
        this.redstoneMode = redstoneMode;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(ValueUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
        buf.writeInt(message.xRange);
        buf.writeInt(message.zRange);
        buf.writeInt(message.yRange);
        buf.writeInt(message.speed);
        buf.writeInt(message.redstoneMode);
    }

    public static ValueUpdateMessage decode(FriendlyByteBuf buf) {
        return new ValueUpdateMessage(buf.readBlockPos(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(PacketContext<ValueUpdateMessage> ctx) {
        if (ctx.side() == Side.SERVER) {
            ValueUpdateMessage.handleServerSide(ctx);
        }
    }

    private static void handleServerSide(PacketContext<ValueUpdateMessage> ctx) {
        ServerPlayer serverPlayer = ctx.sender();
        if (serverPlayer != null) {
            MinecraftServer server = serverPlayer.getServer();
            if (server != null) {
                server.execute(() -> {
                    try {
                        ValueUpdateMessage.handleOnServer((ValueUpdateMessage)ctx.message(), serverPlayer);
                    }
                    catch (Exception e) {
                        ImpatientMod.LOGGER.error("Error updating remote tiers", (Throwable)e);
                    }
                });
            } else {
                ImpatientMod.LOGGER.error("Server is null");
            }
        }
    }

    private static void handleOnServer(ValueUpdateMessage message, ServerPlayer serverPlayer) {
        BlockEntity blockEntity = serverPlayer.level().getBlockEntity(message.pos);
        if (blockEntity instanceof ImpatientBlockEntity) {
            ImpatientBlockEntity blockEntity2 = (ImpatientBlockEntity)blockEntity;
            if (!blockEntity2.readClientData(message.xRange, message.zRange, message.yRange, message.speed, message.redstoneMode)) {
                ImpatientMod.LOGGER.error("Data recived from " + serverPlayer.getName().getString() + "(" + serverPlayer.getStringUUID() + ") is invalid (server)");
            } else {
                blockEntity2.updateRangesFromClient(message.xRange, message.zRange, message.yRange, message.speed, message.redstoneMode);
            }
        }
    }
}

