/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.platform;

import com.google.common.base.Suppliers;
import commonnetwork.api.Dispatcher;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.api.Tier;
import net.biorfn.impatient.network.OpenScreenMessage;
import net.biorfn.impatient.network.S2CTierSyncMessage;
import net.biorfn.impatient.network.ValueUpdateMessage;
import net.biorfn.impatient.platform.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class NetworkUtilsImpl
implements NetworkUtils {
    private static final Supplier<NetworkUtilsImpl> instance = Suppliers.memoize(NetworkUtilsImpl::new);
    private final HashSet<String> allowedUuids = new HashSet();

    public static NetworkUtilsImpl getInstance() {
        return instance.get();
    }

    public void initialize() {
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedOut);
    }

    private void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.allowedUuids.add(player2.getStringUUID());
            S2CTierSyncMessage message = new S2CTierSyncMessage((Map<ResourceLocation, Tier>)ImpatientAPI.INSTANCE.getTiers());
            Dispatcher.sendToClient((Object)message, (ServerPlayer)player2);
        }
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.allowedUuids.remove(player2.getStringUUID());
        }
    }

    @Override
    public void c2s_updateImpatientValues(BlockPos pos, int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        Dispatcher.sendToServer((Object)new ValueUpdateMessage(pos, xRange, zRange, yRange, speed, redstoneMode));
    }

    @Override
    public void s2c_openImpatientScreen(ServerPlayer player, BlockPos pos, Component name, int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        Dispatcher.sendToClient((Object)new OpenScreenMessage(pos, name, xRange, zRange, yRange, speed, redstoneMode), (ServerPlayer)player);
    }

    @Override
    public boolean s_isPlayerOnline(String uuid) {
        return this.allowedUuids.contains(uuid);
    }
}

