/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.registries;

import java.util.HashSet;
import java.util.Set;
import net.biorfn.impatient.ImpatientMod;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ImpatientBlockBlacklist {
    private static final Set<Block> blacklist = new HashSet<Block>();

    public static void addToBlacklist(Block block) {
        if (block != null) {
            blacklist.add(block);
        } else {
            ImpatientMod.LOGGER.warn("Tried to add null block to blacklist.");
        }
    }

    public static void removeFromBlacklist(Block block) {
        if (block != null) {
            blacklist.remove(block);
        } else {
            ImpatientMod.LOGGER.warn("Tried to remove null block from blacklist.");
        }
    }

    public static boolean isBlacklisted(Block block) {
        return blacklist.contains(block);
    }

    public static void addToBlacklist(ResourceLocation blockName) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
        if (block != null) {
            ImpatientBlockBlacklist.addToBlacklist(block);
        } else {
            ImpatientMod.LOGGER.warn("Block not found to add: " + String.valueOf(blockName));
        }
    }

    public static void removeFromBlacklist(ResourceLocation blockName) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
        if (block != null) {
            ImpatientBlockBlacklist.removeFromBlacklist(block);
        } else {
            ImpatientMod.LOGGER.warn("Block not found to remove: " + String.valueOf(blockName));
        }
    }

    public static Set<Block> getBlacklist() {
        return new HashSet<Block>(blacklist);
    }

    static {
        ImpatientBlockBlacklist.addToBlacklist(Blocks.WATER);
        ImpatientBlockBlacklist.addToBlacklist(Blocks.LAVA);
    }
}

