/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.registries;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import net.biorfn.impatient.registries.ImpatientBlockBlacklist;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ImpatientCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"impatient").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blacklist").then(Commands.literal((String)"add").then(Commands.argument((String)"block", (ArgumentType)ResourceLocationArgument.id()).executes(ImpatientCommands::addBlock)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"block", (ArgumentType)ResourceLocationArgument.id()).executes(ImpatientCommands::removeBlock)))).then(Commands.literal((String)"list").executes(ImpatientCommands::listBlacklist))));
    }

    private static int addBlock(CommandContext<CommandSourceStack> context) {
        ResourceLocation blockName = ResourceLocationArgument.getId(context, (String)"block");
        Block block = ImpatientCommands.checkAndAddBlock(blockName, context);
        return block != null ? 1 : 0;
    }

    private static int removeBlock(CommandContext<CommandSourceStack> context) {
        ResourceLocation blockName = ResourceLocationArgument.getId(context, (String)"block");
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
        if (block != null) {
            ImpatientBlockBlacklist.removeFromBlacklist(block);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed block from blacklist: " + String.valueOf(blockName))), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Block not found to remove: " + String.valueOf(blockName))), true);
        return 0;
    }

    private static int listBlacklist(CommandContext<CommandSourceStack> context) {
        Set<Block> blacklist = ImpatientBlockBlacklist.getBlacklist();
        StringBuilder response = new StringBuilder("Blacklisted blocks:");
        for (Block block : blacklist) {
            ResourceLocation blockName = BuiltInRegistries.BLOCK.getKey((Object)block);
            response.append("\n - ").append(blockName);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)response.toString()), false);
        return 1;
    }

    private static Block checkAndAddBlock(ResourceLocation blockName, CommandContext<CommandSourceStack> context) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
        if (block != null) {
            ImpatientBlockBlacklist.addToBlacklist(block);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added block to blacklist: " + String.valueOf(blockName))), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Block not found to add: " + String.valueOf(blockName))), true);
        }
        return block;
    }
}

