/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.registries;

import java.util.function.Supplier;
import net.biorfn.impatient.ClientHelper;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.block.ImpatientBlock;
import net.biorfn.impatient.block.WallImpatientBlock;
import net.biorfn.impatient.block.entity.ImpatientBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="impatient", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"impatient");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"impatient");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"impatient");
    private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"impatient");
    static Supplier<ImpatientBlock> b;

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        PARTICLE_TYPES.register(bus);
        TILE_ENTITIES.register(bus);
        TILE_ENTITIES.register("impatient", () -> BlockEntityType.Builder.of(ImpatientBlockEntity::new, (Block[])BLOCKS.getEntries().stream().map(RegistryObject::get).toList().toArray(new Block[0])).build(null));
        ImpatientAPI.INSTANCE.getTiers().keySet().forEach(ModContent::register);
    }

    private static String getPath(ResourceLocation tierID, String type) {
        return (String)(tierID.getPath().equals("normal") ? "" : tierID.getPath() + "_") + type;
    }

    private static void register(ResourceLocation tierID) {
        if (tierID.getNamespace().equals("impatient")) {
            String impatientPath = ModContent.getPath(tierID, "impatient");
            Supplier<SimpleParticleType> particleType = () -> new SimpleParticleType(false);
            PARTICLE_TYPES.register(ModContent.getPath(tierID, "flame"), particleType);
            RegistryObject standingBlock = BLOCKS.register(impatientPath, () -> new ImpatientBlock((SimpleParticleType)particleType.get(), tierID, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH)));
            RegistryObject wallBlock = BLOCKS.register("wall_" + impatientPath, () -> ModContent.lambda$register$3(particleType, tierID, (Supplier)standingBlock));
            ITEMS.register(impatientPath, () -> ModContent.lambda$register$4((Supplier)standingBlock, (Supplier)wallBlock));
            if (FMLLoader.getDist().isClient()) {
                ClientHelper.registerCutout((Supplier<? extends Block>)standingBlock);
                ClientHelper.registerCutout((Supplier<? extends Block>)wallBlock);
            }
        }
    }

    @SubscribeEvent
    public static void creativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            ITEMS.getEntries().stream().map(RegistryObject::get).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    private static /* synthetic */ StandingAndWallBlockItem lambda$register$4(Supplier standingBlock, Supplier wallBlock) {
        return new StandingAndWallBlockItem((Block)standingBlock.get(), (Block)wallBlock.get(), new Item.Properties(), Direction.DOWN);
    }

    private static /* synthetic */ WallImpatientBlock lambda$register$3(Supplier particleType, ResourceLocation tierID, Supplier standingBlock) {
        return new WallImpatientBlock((SimpleParticleType)particleType.get(), tierID, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).dropsLike((Block)standingBlock.get()));
    }
}

