/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.ClassicChestBlock;
import moi.ellie.storageoptions.block.entity.ChestBlockEntity;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J8\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0018H\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001c\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\f0!H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\fH\u0014JH\u0010'\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0014\u00a8\u00062"}, d2={"Lmoi/ellie/storageoptions/block/ChestBlock;", "Lmoi/ellie/storageoptions/block/ClassicChestBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "newBlockEntity", "Lmoi/ellie/storageoptions/block/entity/ChestBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "codec", "Lcom/mojang/serialization/MapCodec;", "getDoubleContainerName", "Lnet/minecraft/network/chat/Component;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "getStateForPlacement", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "updateShape", "Lnet/minecraft/world/level/LevelReader;", "tickScheduler", "Lnet/minecraft/world/level/ScheduledTickAccess;", "direction", "Lnet/minecraft/core/Direction;", "neighborPos", "neighborState", "random", "Lnet/minecraft/util/RandomSource;", "Companion", "ellsso-neoforge-1.21.10"})
public final class ChestBlock
extends ClassicChestBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<? extends ChestBlock> CODEC;
    @NotNull
    private static final VoxelShape SINGLE_SHAPE;
    @NotNull
    private static final VoxelShape NORTH_SHAPE;
    @NotNull
    private static final VoxelShape EAST_SHAPE;
    @NotNull
    private static final VoxelShape SOUTH_SHAPE;
    @NotNull
    private static final VoxelShape WEST_SHAPE;

    public ChestBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @Nullable
    public ChestBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (ChestBlockEntity)ModBlockEntities.INSTANCE.getCHEST().create(pos, state);
    }

    @NotNull
    protected MapCodec<? extends ChestBlock> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Component getDoubleContainerName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.chestDouble");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ChestBlockEntity.Companion companion = ChestBlockEntity.Companion;
        return BaseEntityBlock.createTickerHelper(type, ModBlockEntities.INSTANCE.getCHEST(), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ ChestBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, ChestBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = ClassicChestBlock.Companion.getConnectedDirection(state);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> NORTH_SHAPE;
            case 2 -> EAST_SHAPE;
            case 3 -> SOUTH_SHAPE;
            case 4 -> WEST_SHAPE;
            default -> SINGLE_SHAPE;
        };
    }

    @Override
    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.createBlockStateDefinition(builder);
        Property[] propertyArray = new Property[]{BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean placingInWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        BlockState blockState = super.getStateForPlacement(context);
        return blockState != null ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(placingInWater)) : null;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @Override
    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickScheduler, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)tickScheduler, (String)"tickScheduler");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickScheduler.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickScheduler, pos, direction, neighborPos, neighborState, random);
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(ChestBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        VoxelShape voxelShape = BaseEntityBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SINGLE_SHAPE = voxelShape;
        VoxelShape voxelShape2 = BaseEntityBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        NORTH_SHAPE = voxelShape2;
        VoxelShape voxelShape3 = BaseEntityBlock.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        EAST_SHAPE = voxelShape3;
        VoxelShape voxelShape4 = BaseEntityBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        SOUTH_SHAPE = voxelShape4;
        VoxelShape voxelShape5 = BaseEntityBlock.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"box(...)");
        WEST_SHAPE = voxelShape5;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u0015"}, d2={"Lmoi/ellie/storageoptions/block/ChestBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lmoi/ellie/storageoptions/block/ChestBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "SINGLE_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSINGLE_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_SHAPE", "getNORTH_SHAPE", "EAST_SHAPE", "getEAST_SHAPE", "SOUTH_SHAPE", "getSOUTH_SHAPE", "WEST_SHAPE", "getWEST_SHAPE", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<? extends ChestBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final VoxelShape getSINGLE_SHAPE() {
            return SINGLE_SHAPE;
        }

        @NotNull
        public final VoxelShape getNORTH_SHAPE() {
            return NORTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getEAST_SHAPE() {
            return EAST_SHAPE;
        }

        @NotNull
        public final VoxelShape getSOUTH_SHAPE() {
            return SOUTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getWEST_SHAPE() {
            return WEST_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

