/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.DoubleInventoryBlock;
import moi.ellie.storageoptions.block.entity.ClassicChestBlockEntity;
import moi.ellie.storageoptions.block.misc.ChestType;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JH\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u001bH\u0014J\u001e\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00070$H\u0014J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\"2\u0006\u0010\f\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016\u00a8\u00060"}, d2={"Lmoi/ellie/storageoptions/block/ClassicChestBlock;", "Lmoi/ellie/storageoptions/block/DoubleInventoryBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "state", "level", "Lnet/minecraft/world/level/LevelReader;", "tickScheduler", "Lnet/minecraft/world/level/ScheduledTickAccess;", "pos", "Lnet/minecraft/core/BlockPos;", "direction", "Lnet/minecraft/core/Direction;", "neighborPos", "neighborState", "random", "Lnet/minecraft/util/RandomSource;", "getDoubleContainerName", "Lnet/minecraft/network/chat/Component;", "codec", "Lcom/mojang/serialization/MapCodec;", "newBlockEntity", "Lmoi/ellie/storageoptions/block/entity/ClassicChestBlockEntity;", "isAccessBlocked", "", "Lnet/minecraft/world/level/Level;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "rotate", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "mirror", "Lnet/minecraft/world/level/block/Mirror;", "onOpen", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/world/entity/player/Player;", "Companion", "ellsso-neoforge-1.21.10"})
public class ClassicChestBlock
extends DoubleInventoryBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EnumProperty<ChestType> CHEST_TYPE;
    @NotNull
    private static final MapCodec<? extends ClassicChestBlock> CODEC;

    public ClassicChestBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)CHEST_TYPE, (Comparable)((Object)ChestType.SINGLE)));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ChestType chestType = ChestType.SINGLE;
        Direction chestFacing = context.getHorizontalDirection().getOpposite();
        if (context.isSecondaryUseActive()) {
            BlockState clickedState;
            Direction offset = context.getClickedFace().getOpposite();
            if (offset.getAxis().isHorizontal() && (clickedState = context.getLevel().getBlockState(context.getClickedPos().relative(offset))).is((Block)this) && clickedState.getValue((Property)CHEST_TYPE) == ChestType.SINGLE) {
                Direction clickedFacing = (Direction)clickedState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (clickedFacing.getClockWise() == offset) {
                    chestType = ChestType.RIGHT;
                    chestFacing = clickedFacing;
                } else if (clickedFacing.getCounterClockWise() == offset) {
                    chestType = ChestType.LEFT;
                    chestFacing = clickedFacing;
                }
            }
        } else {
            BlockState leftState = context.getLevel().getBlockState(context.getClickedPos().relative(chestFacing.getClockWise()));
            if (leftState.is((Block)this) && leftState.getValue((Property)CHEST_TYPE) == ChestType.SINGLE && leftState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == chestFacing) {
                chestType = ChestType.RIGHT;
            } else {
                BlockState rightState = context.getLevel().getBlockState(context.getClickedPos().relative(chestFacing.getCounterClockWise()));
                if (rightState.is((Block)this) && rightState.getValue((Property)CHEST_TYPE) == ChestType.SINGLE && rightState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == chestFacing) {
                    chestType = ChestType.LEFT;
                }
            }
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)CHEST_TYPE, (Comparable)((Object)chestType))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)chestFacing);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickScheduler, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)tickScheduler, (String)"tickScheduler");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (neighborState.is((Block)this) && direction.getAxis().isHorizontal()) {
            ChestType chestType = (ChestType)((Object)neighborState.getValue((Property)CHEST_TYPE));
            Direction facing = (Direction)neighborState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (state.getValue((Property)CHEST_TYPE) == ChestType.SINGLE && chestType != ChestType.SINGLE && state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing) {
                Intrinsics.checkNotNull((Object)((Object)chestType));
                Intrinsics.checkNotNull((Object)facing);
                Direction direction2 = Companion.getConnectedDirection(chestType, facing);
                if (direction == (direction2 != null ? direction2.getOpposite() : null)) {
                    Object object = state.setValue((Property)CHEST_TYPE, (Comparable)((Object)(chestType == ChestType.LEFT ? ChestType.RIGHT : ChestType.LEFT)));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                    return (BlockState)object;
                }
            }
        } else if (Companion.getConnectedDirection(state) == direction) {
            Object object = state.setValue((Property)CHEST_TYPE, (Comparable)((Object)ChestType.SINGLE));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        BlockState blockState = super.updateShape(state, level, tickScheduler, pos, direction, neighborPos, neighborState, random);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @Override
    @NotNull
    public Component getDoubleContainerName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.ellsso.large_classic_chest");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    protected MapCodec<? extends ClassicChestBlock> codec() {
        return CODEC;
    }

    @Nullable
    public ClassicChestBlockEntity<?> newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (ClassicChestBlockEntity)ModBlockEntities.INSTANCE.getCLASSIC_CHEST().create(pos, state);
    }

    @Override
    public boolean isAccessBlocked(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos abovePos = pos.relative(Direction.UP);
        BlockState aboveState = level.getBlockState(abovePos);
        if (aboveState.isRedstoneConductor((BlockGetter)level, abovePos) && aboveState.getMenuProvider(level, abovePos) == null) {
            return true;
        }
        return ChestBlock.isCatSittingOnChest((LevelAccessor)((LevelAccessor)level), (BlockPos)pos);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, CHEST_TYPE};
        builder.add(propertyArray);
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        Object object = state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Override
    public void onOpen(@NotNull ServerLevel level, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onOpen(level, player);
        player.awardStat(Stats.OPEN_CHEST);
    }

    static {
        EnumProperty enumProperty = EnumProperty.create((String)"type", ChestType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"create(...)");
        CHEST_TYPE = enumProperty;
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(ClassicChestBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lmoi/ellie/storageoptions/block/ClassicChestBlock$Companion;", "", "<init>", "()V", "CHEST_TYPE", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lmoi/ellie/storageoptions/block/misc/ChestType;", "getCHEST_TYPE", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lmoi/ellie/storageoptions/block/ClassicChestBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "getConnectedDirection", "Lnet/minecraft/core/Direction;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "type", "facing", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumProperty<ChestType> getCHEST_TYPE() {
            return CHEST_TYPE;
        }

        @NotNull
        public final MapCodec<? extends ClassicChestBlock> getCODEC() {
            return CODEC;
        }

        @Nullable
        public final Direction getConnectedDirection(@NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Comparable comparable = state.getValue((Property)this.getCHEST_TYPE());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            ChestType chestType = (ChestType)((Object)comparable);
            Comparable comparable2 = state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getValue(...)");
            return this.getConnectedDirection(chestType, (Direction)comparable2);
        }

        @Nullable
        public final Direction getConnectedDirection(@NotNull ChestType type, @NotNull Direction facing) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> facing.getCounterClockWise();
                case 2 -> facing.getClockWise();
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChestType.values().length];
                try {
                    nArray[ChestType.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChestType.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

