/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.InventoryBlock;
import moi.ellie.storageoptions.block.entity.DoubleInventoryBlockEntity;
import moi.ellie.storageoptions.block.misc.CachedDoubleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lmoi/ellie/storageoptions/block/DoubleInventoryBlock;", "Lmoi/ellie/storageoptions/block/InventoryBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getDoubleContainerName", "Lnet/minecraft/network/chat/Component;", "getMenuProvider", "Lnet/minecraft/world/MenuProvider;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "getAnalogOutputSignal", "", "direction", "Lnet/minecraft/core/Direction;", "ellsso-neoforge-1.21.10"})
public abstract class DoubleInventoryBlock
extends InventoryBlock {
    public DoubleInventoryBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public abstract Component getDoubleContainerName();

    @Override
    @Nullable
    protected MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        CompoundContainer inventory;
        Object second;
        Object first;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                BlockEntity blockEntity = level.getBlockEntity(pos);
                DoubleInventoryBlockEntity doubleInventoryBlockEntity = blockEntity instanceof DoubleInventoryBlockEntity ? (DoubleInventoryBlockEntity)blockEntity : null;
                if (doubleInventoryBlockEntity == null) {
                    return null;
                }
                DoubleInventoryBlockEntity entity = doubleInventoryBlockEntity;
                CachedDoubleBlock doubleCache = entity.getDoubleCache();
                if (doubleCache == null) {
                    return super.getMenuProvider(state, level, pos);
                }
                first = doubleCache.getFirst();
                second = doubleCache.getSecond();
                inventory = doubleCache.getContainer();
                BlockState blockState = first.getBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                BlockPos blockPos = first.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                if (this.isAccessBlocked(level, blockState, blockPos)) break block6;
                BlockState blockState2 = second.getBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
                BlockPos blockPos2 = second.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                if (!this.isAccessBlocked(level, blockState2, blockPos2)) break block7;
            }
            return null;
        }
        MenuConstructor menuConstructor = (arg_0, arg_1, arg_2) -> DoubleInventoryBlock.getMenuProvider$lambda$0(first, second, inventory, arg_0, arg_1, arg_2);
        Component component = first.getCustomName();
        if (component == null && (component = second.getCustomName()) == null) {
            component = this.getDoubleContainerName();
        }
        return (MenuProvider)new SimpleMenuProvider(menuConstructor, component);
    }

    @Override
    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        DoubleInventoryBlockEntity doubleInventoryBlockEntity = blockEntity instanceof DoubleInventoryBlockEntity ? (DoubleInventoryBlockEntity)blockEntity : null;
        if (doubleInventoryBlockEntity == null) {
            return 0;
        }
        DoubleInventoryBlockEntity entity = doubleInventoryBlockEntity;
        CachedDoubleBlock doubleCache = entity.getDoubleCache();
        return doubleCache == null ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)entity)) : AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)doubleCache.getContainer()));
    }

    private static final AbstractContainerMenu getMenuProvider$lambda$0(DoubleInventoryBlockEntity<?> first, DoubleInventoryBlockEntity<?> second, CompoundContainer inventory, int id, Inventory playerInventory, Player player) {
        AbstractContainerMenu abstractContainerMenu;
        if (first.canOpen(player) && second.canOpen(player)) {
            first.unpackLootTable(player);
            second.unpackLootTable(player);
            abstractContainerMenu = (AbstractContainerMenu)ChestMenu.sixRows((int)id, (Inventory)playerInventory, (Container)((Container)inventory));
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }
}

