/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.entity.InventoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J(\u0010 \u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0007H\u0014\u00a8\u0006\""}, d2={"Lmoi/ellie/storageoptions/block/InventoryBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "isAccessBlocked", "", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "hasAnalogOutputSignal", "getAnalogOutputSignal", "", "direction", "Lnet/minecraft/core/Direction;", "onOpen", "", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/world/entity/player/Player;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "getMenuProvider", "Lnet/minecraft/world/MenuProvider;", "affectNeighborsAfterRemoval", "movedByPiston", "ellsso-neoforge-1.21.10"})
public abstract class InventoryBlock
extends BaseEntityBlock {
    public InventoryBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public boolean isAccessBlocked(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return false;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        InventoryBlockEntity inventoryBlockEntity = blockEntity instanceof InventoryBlockEntity ? (InventoryBlockEntity)blockEntity : null;
        if (inventoryBlockEntity == null) {
            return 0;
        }
        InventoryBlockEntity entity = inventoryBlockEntity;
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)entity));
    }

    @MustBeInvokedByOverriders
    public void onOpen(@NotNull ServerLevel level, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PiglinAi.angerNearbyPiglins((ServerLevel)level, (Player)player, (boolean)true);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (level.isClientSide()) {
            InteractionResult.Success success = InteractionResult.SUCCESS;
            Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
            return (InteractionResult)success;
        }
        MenuProvider menuProvider = this.getMenuProvider(state, level, pos);
        if (menuProvider != null) {
            MenuProvider it = menuProvider;
            boolean bl = false;
            player.openMenu(it);
            this.onOpen((ServerLevel)level, player);
        }
        InteractionResult.Success success = InteractionResult.CONSUME;
        Intrinsics.checkNotNullExpressionValue((Object)success, (String)"CONSUME");
        return (InteractionResult)success;
    }

    @Nullable
    protected MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.isAccessBlocked(level, state, pos)) {
            return null;
        }
        return super.getMenuProvider(state, level, pos);
    }

    protected void affectNeighborsAfterRemoval(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)((Level)level), (BlockPos)pos);
    }
}

