/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.InventoryBlock;
import moi.ellie.storageoptions.block.entity.ShulkerBoxBlockEntity;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0013H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0017H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J8\u0010&\u001a\n\u0012\u0004\u0012\u0002H(\u0018\u00010'\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0+H\u0016J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0014J\u001e\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0014J \u00106\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00068"}, d2={"Lmoi/ellie/storageoptions/block/ShulkerBoxBlock;", "Lmoi/ellie/storageoptions/block/InventoryBlock;", "color", "Lnet/minecraft/world/item/DyeColor;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/item/DyeColor;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getColor", "()Lnet/minecraft/world/item/DyeColor;", "isAccessBlocked", "", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "codec", "Lcom/mojang/serialization/MapCodec;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "newBlockEntity", "Lmoi/ellie/storageoptions/block/entity/ShulkerBoxBlockEntity;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "playerWillDestroy", "player", "Lnet/minecraft/world/entity/player/Player;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "propagatesSkylightDown", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "rotate", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "mirror", "Lnet/minecraft/world/level/block/Mirror;", "getDrops", "", "Lnet/minecraft/world/item/ItemStack;", "params", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "getBlockSupportShape", "Companion", "ellsso-neoforge-1.21.10"})
public final class ShulkerBoxBlock
extends InventoryBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DyeColor color;
    @NotNull
    private static final MapCodec<ShulkerBoxBlock> CODEC;
    @NotNull
    private static final Map<Direction, VoxelShape> BLOCK_SUPPORT_SHAPES;

    public ShulkerBoxBlock(@Nullable DyeColor color, @NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
    }

    @Nullable
    public final DyeColor getColor() {
        return this.color;
    }

    @Override
    public boolean isAccessBlocked(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return !level.noCollision(Shulker.getProgressDeltaAabb((float)1.0f, (Direction)((Direction)state.getValue((Property)BlockStateProperties.FACING)), (float)0.0f, (float)0.5f, (Vec3)pos.getBottomCenter()));
        }
        return true;
    }

    @NotNull
    protected MapCodec<? extends ShulkerBoxBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.FACING};
        builder.add(propertyArray);
    }

    @Nullable
    public ShulkerBoxBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (ShulkerBoxBlockEntity)ModBlockEntities.INSTANCE.getSHULKER_BOX().create(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        level.getBlockEntity(pos, ModBlockEntities.INSTANCE.getSHULKER_BOX()).ifPresent(arg_0 -> ShulkerBoxBlock.playerWillDestroy$lambda$1(arg_0 -> ShulkerBoxBlock.playerWillDestroy$lambda$0(level, player, this, pos, arg_0), arg_0));
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = level.getBlockEntity(pos, ModBlockEntities.INSTANCE.getSHULKER_BOX()).map(arg_0 -> ShulkerBoxBlock.getShape$lambda$1(ShulkerBoxBlock::getShape$lambda$0, arg_0)).orElse(Shapes.block());
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"orElse(...)");
        return voxelShape;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ShulkerBoxBlockEntity.Companion companion = ShulkerBoxBlockEntity.Companion;
        return BaseEntityBlock.createTickerHelper(type, ModBlockEntities.INSTANCE.getSHULKER_BOX(), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ ShulkerBoxBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, ShulkerBoxBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        Object object = state.setValue((Property)BlockStateProperties.FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder params) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        ShulkerBoxBlockEntity shulkerBoxBlockEntity = object instanceof ShulkerBoxBlockEntity ? (ShulkerBoxBlockEntity)((Object)object) : null;
        if (shulkerBoxBlockEntity == null) {
            List list = super.getDrops(state, params);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
            return list;
        }
        ShulkerBoxBlockEntity entity = shulkerBoxBlockEntity;
        LootParams.Builder params2 = params.withDynamicDrop(ResourceLocation.withDefaultNamespace((String)"contents"), arg_0 -> ShulkerBoxBlock.getDrops$lambda$0(entity, arg_0));
        List list = super.getDrops(state, params2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
        return list;
    }

    @NotNull
    protected VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        VoxelShape voxelShape = level.getBlockEntity(pos, ModBlockEntities.INSTANCE.getSHULKER_BOX()).map(arg_0 -> ShulkerBoxBlock.getBlockSupportShape$lambda$1(ShulkerBoxBlock::getBlockSupportShape$lambda$0, arg_0)).orElse(Shapes.block());
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"orElse(...)");
        return voxelShape;
    }

    private static final Unit playerWillDestroy$lambda$0(Level $level, Player $player, ShulkerBoxBlock this$0, BlockPos $pos, ShulkerBoxBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        if (!$level.isClientSide() && $player.isCreative() && !entity.isEmpty()) {
            ItemStack stack = this$0.asItem().getDefaultInstance();
            stack.applyComponents(entity.collectComponents());
            ItemEntity item = new ItemEntity($level, (double)$pos.getX() + 0.5, (double)$pos.getY() + 0.5, (double)$pos.getZ() + 0.5, stack);
            item.setDefaultPickUpDelay();
            $level.addFreshEntity((Entity)item);
        } else {
            entity.unpackLootTable($player);
        }
        return Unit.INSTANCE;
    }

    private static final void playerWillDestroy$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final VoxelShape getShape$lambda$0(ShulkerBoxBlockEntity entity) {
        return Shapes.create((AABB)Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)entity.getBlockState().getValue((Property)BlockStateProperties.FACING)), (float)(0.5f * entity.getOpenNess(1.0f)), (Vec3)new Vec3(0.5, 0.0, 0.5)));
    }

    private static final VoxelShape getShape$lambda$1(Function1 $tmp0, Object p0) {
        return (VoxelShape)$tmp0.invoke(p0);
    }

    private static final void getDrops$lambda$0(ShulkerBoxBlockEntity $entity, Consumer thing) {
        int n = $entity.getContainerSize();
        for (int i = 0; i < n; ++i) {
            thing.accept($entity.getItem(i));
        }
    }

    private static final VoxelShape getBlockSupportShape$lambda$0(ShulkerBoxBlockEntity entity) {
        VoxelShape voxelShape;
        if (entity.getOpenNess(1.0f) == 0.0f) {
            voxelShape = Shapes.block();
        } else {
            VoxelShape voxelShape2 = BLOCK_SUPPORT_SHAPES.get(((Direction)entity.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
            Intrinsics.checkNotNull((Object)voxelShape2);
            voxelShape = voxelShape2;
        }
        return voxelShape;
    }

    private static final VoxelShape getBlockSupportShape$lambda$1(Function1 $tmp0, Object p0) {
        return (VoxelShape)$tmp0.invoke(p0);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)BaseEntityBlock.propertiesCodec(), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(ShulkerBoxBlock::CODEC$lambda$0$0)).apply((Applicative)instance, ShulkerBoxBlock::CODEC$lambda$0$1);
    }

    private static final Optional CODEC$lambda$0$0(ShulkerBoxBlock block) {
        return Optional.ofNullable(block.color);
    }

    private static final ShulkerBoxBlock CODEC$lambda$0$1(BlockBehaviour.Properties properties, Optional color) {
        DyeColor dyeColor = color.orElse(null);
        Intrinsics.checkNotNull((Object)properties);
        return new ShulkerBoxBlock(dyeColor, properties);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(ShulkerBoxBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Direction.NORTH, (Object)BaseEntityBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)), TuplesKt.to((Object)Direction.EAST, (Object)BaseEntityBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), TuplesKt.to((Object)Direction.SOUTH, (Object)BaseEntityBlock.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)), TuplesKt.to((Object)Direction.WEST, (Object)BaseEntityBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)), TuplesKt.to((Object)Direction.UP, (Object)BaseEntityBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), TuplesKt.to((Object)Direction.DOWN, (Object)BaseEntityBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0))};
        BLOCK_SUPPORT_SHAPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR%\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lmoi/ellie/storageoptions/block/ShulkerBoxBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lmoi/ellie/storageoptions/block/ShulkerBoxBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "BLOCK_SUPPORT_SHAPES", "", "Lnet/minecraft/core/Direction;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getBLOCK_SUPPORT_SHAPES", "()Ljava/util/Map;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<ShulkerBoxBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final Map<Direction, VoxelShape> getBLOCK_SUPPORT_SHAPES() {
            return BLOCK_SUPPORT_SHAPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

