/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block;

import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.DoubleInventoryBlock;
import moi.ellie.storageoptions.block.entity.TallBarrelBlockEntity;
import moi.ellie.storageoptions.block.misc.BarrelType;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JH\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u001dH\u0014J\u001c\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00070!H\u0014J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J(\u0010,\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006."}, d2={"Lmoi/ellie/storageoptions/block/TallBarrelBlock;", "Lmoi/ellie/storageoptions/block/DoubleInventoryBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "state", "level", "Lnet/minecraft/world/level/LevelReader;", "tickScheduler", "Lnet/minecraft/world/level/ScheduledTickAccess;", "pos", "Lnet/minecraft/core/BlockPos;", "direction", "Lnet/minecraft/core/Direction;", "neighborPos", "neighborState", "random", "Lnet/minecraft/util/RandomSource;", "getDoubleContainerName", "Lnet/minecraft/network/chat/Component;", "newBlockEntity", "Lmoi/ellie/storageoptions/block/entity/TallBarrelBlockEntity;", "codec", "Lcom/mojang/serialization/MapCodec;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "rotate", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "mirror", "Lnet/minecraft/world/level/block/Mirror;", "onOpen", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/world/entity/player/Player;", "tick", "Companion", "ellsso-neoforge-1.21.10"})
public final class TallBarrelBlock
extends DoubleInventoryBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EnumProperty<BarrelType> BARREL_TYPE;
    @NotNull
    private static final MapCodec<? extends TallBarrelBlock> CODEC;

    public TallBarrelBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BARREL_TYPE, (Comparable)((Object)BarrelType.SINGLE)));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        if (context.isSecondaryUseActive()) {
            BlockState clickedBlock = level.getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()));
            if (clickedBlock.is((Block)this) && clickedBlock.getValue((Property)BARREL_TYPE) == BarrelType.SINGLE && clickedBlock.getValue((Property)BlockStateProperties.FACING) == context.getClickedFace()) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace())).setValue((Property)BARREL_TYPE, (Comparable)((Object)BarrelType.TOP));
            }
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
        }
        Direction facing = context.getNearestLookingDirection().getOpposite();
        BlockState placingOnBlock = level.getBlockState(context.getClickedPos().relative(context.getNearestLookingDirection()));
        BlockState inversePlacingOnBlock = level.getBlockState(context.getClickedPos().relative(facing));
        BarrelType barrelType = placingOnBlock.is((Block)this) && placingOnBlock.getValue((Property)BlockStateProperties.FACING) == facing && placingOnBlock.getValue((Property)BARREL_TYPE) == BarrelType.SINGLE ? BarrelType.TOP : (inversePlacingOnBlock.is((Block)this) && inversePlacingOnBlock.getValue((Property)BlockStateProperties.FACING) == facing && inversePlacingOnBlock.getValue((Property)BARREL_TYPE) == BarrelType.SINGLE ? BarrelType.BOTTOM : BarrelType.SINGLE);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing)).setValue((Property)BARREL_TYPE, (Comparable)((Object)barrelType));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickScheduler, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)tickScheduler, (String)"tickScheduler");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (neighborState.is((Block)this)) {
            BarrelType partnerType = (BarrelType)((Object)neighborState.getValue((Property)BARREL_TYPE));
            Direction partnerFacing = (Direction)neighborState.getValue((Property)BlockStateProperties.FACING);
            if (state.getValue((Property)BARREL_TYPE) == BarrelType.SINGLE) {
                if (partnerType == BarrelType.TOP && partnerFacing == direction) {
                    Object object = state.setValue((Property)BARREL_TYPE, (Comparable)((Object)BarrelType.BOTTOM));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                    return (BlockState)object;
                }
                if (partnerType == BarrelType.BOTTOM && partnerFacing.getOpposite() == direction) {
                    Object object = state.setValue((Property)BARREL_TYPE, (Comparable)((Object)BarrelType.TOP));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                    return (BlockState)object;
                }
            }
        } else if (Companion.getConnectedDirection(state) == direction) {
            Object object = state.setValue((Property)BARREL_TYPE, (Comparable)((Object)BarrelType.SINGLE));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        BlockState blockState = super.updateShape(state, level, tickScheduler, pos, direction, neighborPos, neighborState, random);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    @Override
    @NotNull
    public Component getDoubleContainerName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.ellsso.barrel");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @Nullable
    public TallBarrelBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (TallBarrelBlockEntity)ModBlockEntities.INSTANCE.getBARREL().create(pos, state);
    }

    @NotNull
    protected MapCodec<? extends TallBarrelBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.FACING, BlockStateProperties.OPEN, BARREL_TYPE};
        builder.add(propertyArray);
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        Object object = state.setValue((Property)BlockStateProperties.FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Override
    public void onOpen(@NotNull ServerLevel level, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onOpen(level, player);
        player.awardStat(Stats.OPEN_BARREL);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        TallBarrelBlockEntity tallBarrelBlockEntity = blockEntity instanceof TallBarrelBlockEntity ? (TallBarrelBlockEntity)blockEntity : null;
        if (tallBarrelBlockEntity == null) {
            return;
        }
        TallBarrelBlockEntity entity = tallBarrelBlockEntity;
        entity.recheckOpen();
    }

    static {
        EnumProperty enumProperty = EnumProperty.create((String)"type", BarrelType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"create(...)");
        BARREL_TYPE = enumProperty;
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(TallBarrelBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lmoi/ellie/storageoptions/block/TallBarrelBlock$Companion;", "", "<init>", "()V", "BARREL_TYPE", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lmoi/ellie/storageoptions/block/misc/BarrelType;", "getBARREL_TYPE", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lmoi/ellie/storageoptions/block/TallBarrelBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "getConnectedDirection", "Lnet/minecraft/core/Direction;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumProperty<BarrelType> getBARREL_TYPE() {
            return BARREL_TYPE;
        }

        @NotNull
        public final MapCodec<? extends TallBarrelBlock> getCODEC() {
            return CODEC;
        }

        @Nullable
        public final Direction getConnectedDirection(@NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            BarrelType type = (BarrelType)((Object)state.getValue((Property)this.getBARREL_TYPE()));
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BarrelType barrelType = type;
            return switch (barrelType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[barrelType.ordinal()]) {
                case 1 -> facing.getOpposite();
                case 2 -> facing;
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BarrelType.values().length];
                try {
                    nArray[BarrelType.TOP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BarrelType.BOTTOM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

