/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.ClassicChestBlock;
import moi.ellie.storageoptions.block.entity.ClassicChestBlockEntity;
import moi.ellie.storageoptions.block.misc.ChestType;
import moi.ellie.storageoptions.block.misc.LidController;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lmoi/ellie/storageoptions/block/entity/ChestBlockEntity;", "Lmoi/ellie/storageoptions/block/entity/ClassicChestBlockEntity;", "Lnet/minecraft/world/level/block/entity/LidBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "lidController", "Lmoi/ellie/storageoptions/block/misc/LidController;", "getLidController", "()Lmoi/ellie/storageoptions/block/misc/LidController;", "openersCounter", "Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "getOpenersCounter", "()Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "getOpenNess", "", "partialTicks", "updateAnimation", "", "level", "Lnet/minecraft/world/level/Level;", "startOpen", "user", "Lnet/minecraft/world/entity/ContainerUser;", "stopOpen", "triggerEvent", "", "id", "", "type", "Companion", "ellsso-neoforge-1.21.10"})
public final class ChestBlockEntity
extends ClassicChestBlockEntity<ChestBlockEntity>
implements LidBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LidController lidController;
    @NotNull
    private final ContainerOpenersCounter openersCounter;

    public ChestBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(ModBlockEntities.INSTANCE.getCHEST(), pos, state);
        this.lidController = new LidController();
        this.openersCounter = new ContainerOpenersCounter(this){
            final /* synthetic */ ChestBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                SoundEvent soundEvent = SoundEvents.CHEST_OPEN;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"CHEST_OPEN");
                ChestBlockEntity.Companion.playSound(level, pos, state, soundEvent);
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                SoundEvent soundEvent = SoundEvents.CHEST_CLOSE;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"CHEST_CLOSE");
                ChestBlockEntity.Companion.playSound(level, pos, state, soundEvent);
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int oldCount, int count) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                level.blockEvent(pos, state.getBlock(), 2, count);
            }

            public boolean isOwnContainer(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                ChestMenu chestMenu = abstractContainerMenu instanceof ChestMenu ? (ChestMenu)abstractContainerMenu : null;
                if (chestMenu == null) {
                    return false;
                }
                ChestMenu menu = chestMenu;
                if (Intrinsics.areEqual((Object)menu.getContainer(), (Object)((Object)this))) {
                    return true;
                }
                Container container = menu.getContainer();
                CompoundContainer compoundContainer = container instanceof CompoundContainer ? (CompoundContainer)container : null;
                if (compoundContainer == null) {
                    return false;
                }
                CompoundContainer doubleContainer = compoundContainer;
                return doubleContainer.contains((Container)this.this$0);
            }
        };
    }

    @NotNull
    public final LidController getLidController() {
        return this.lidController;
    }

    @NotNull
    public final ContainerOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.chest");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public float getOpenNess(float partialTicks) {
        return this.lidController.getOpenNess(partialTicks);
    }

    public final void updateAnimation(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.lidController.tickLid(level, pos, state);
    }

    public void startOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        this.openersCounter.incrementOpeners(user.getLivingEntity(), level2, this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
    }

    public void stopOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        this.openersCounter.decrementOpeners(user.getLivingEntity(), level2, this.getBlockPos(), this.getBlockState());
    }

    @Override
    public boolean triggerEvent(int id, int type) {
        if (id == 2) {
            this.lidController.setOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lmoi/ellie/storageoptions/block/entity/ChestBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "entity", "Lmoi/ellie/storageoptions/block/entity/ChestBlockEntity;", "playSound", "sound", "Lnet/minecraft/sounds/SoundEvent;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ChestBlockEntity entity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            if (level.isClientSide()) {
                entity.updateAnimation(level, pos, state);
            }
        }

        public final void playSound(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull SoundEvent sound) {
            Vec3 vec3;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            ChestType type = (ChestType)((Object)state.getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE()));
            if (type == ChestType.RIGHT) {
                return;
            }
            if (type == ChestType.SINGLE) {
                vec3 = pos.getCenter();
            } else {
                Vec3 vec32 = pos.getCenter();
                Direction direction = ClassicChestBlock.Companion.getConnectedDirection(state);
                Intrinsics.checkNotNull((Object)direction);
                vec3 = vec32.relative(direction, 0.5);
            }
            Vec3 soundPos = vec3.add(0.0, 0.5, 0.0);
            level.playSound(null, soundPos.x, soundPos.y, soundPos.z, sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

