/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.ClassicChestBlock;
import moi.ellie.storageoptions.block.entity.DoubleInventoryBlockEntity;
import moi.ellie.storageoptions.block.misc.CachedDoubleBlock;
import moi.ellie.storageoptions.block.misc.ChestType;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0015"}, d2={"Lmoi/ellie/storageoptions/block/entity/ClassicChestBlockEntity;", "E", "Lmoi/ellie/storageoptions/block/entity/DoubleInventoryBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "ensureDoubleCache", "Lmoi/ellie/storageoptions/block/misc/CachedDoubleBlock;", "areStatesMeaningfullyDifferent", "", "first", "second", "isSingleState", "ellsso-neoforge-1.21.10"})
public class ClassicChestBlockEntity<E extends DoubleInventoryBlockEntity<? extends E>>
extends DoubleInventoryBlockEntity<E> {
    public ClassicChestBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public ClassicChestBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this(ModBlockEntities.INSTANCE.getCLASSIC_CHEST(), pos, state);
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.ellsso.classic_chest");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @Override
    @Nullable
    protected CachedDoubleBlock<E> ensureDoubleCache() {
        ChestType chestType = (ChestType)((Object)this.getBlockState().getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE()));
        if (chestType != ChestType.SINGLE) {
            ClassicChestBlockEntity otherEntity;
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            BlockPos blockPos = this.getBlockPos();
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Direction direction = ClassicChestBlock.Companion.getConnectedDirection(blockState);
            Intrinsics.checkNotNull((Object)direction);
            BlockEntity blockEntity = level.getBlockEntity(blockPos.relative(direction));
            ClassicChestBlockEntity classicChestBlockEntity = otherEntity = blockEntity instanceof ClassicChestBlockEntity ? (ClassicChestBlockEntity)blockEntity : null;
            if (otherEntity != null) {
                CachedDoubleBlock<DoubleInventoryBlockEntity> doubleCache = chestType == ChestType.LEFT ? new CachedDoubleBlock<DoubleInventoryBlockEntity>(this, otherEntity) : new CachedDoubleBlock<DoubleInventoryBlockEntity>(otherEntity, this);
                doubleCache.getFirst().setDoubleCache$ellsso_neoforge_1_21_10(doubleCache);
                doubleCache.getSecond().setDoubleCache$ellsso_neoforge_1_21_10(doubleCache);
                return doubleCache;
            }
        }
        return null;
    }

    @Override
    protected boolean areStatesMeaningfullyDifferent(@NotNull BlockState first, @NotNull BlockState second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return first.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != second.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) || first.getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE()) != second.getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE());
    }

    @Override
    protected boolean isSingleState(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE()) == ChestType.SINGLE;
    }
}

