/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.entity;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.ShulkerBoxBlock;
import moi.ellie.storageoptions.block.entity.InventoryBlockEntity;
import moi.ellie.storageoptions.block.misc.LidController;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$H\u0016J\u0006\u0010/\u001a\u00020\u001dJ\u0018\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lmoi/ellie/storageoptions/block/entity/ShulkerBoxBlockEntity;", "Lmoi/ellie/storageoptions/block/entity/InventoryBlockEntity;", "Lnet/minecraft/world/level/block/entity/LidBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "color", "Lnet/minecraft/world/item/DyeColor;", "getColor", "()Lnet/minecraft/world/item/DyeColor;", "lidController", "Lmoi/ellie/storageoptions/block/misc/LidController;", "getLidController", "()Lmoi/ellie/storageoptions/block/misc/LidController;", "setLidController", "(Lmoi/ellie/storageoptions/block/misc/LidController;)V", "openersCounter", "Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "getOpenersCounter", "()Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "getOpenNess", "", "partialTicks", "preRemoveSideEffects", "", "updateAnimation", "level", "Lnet/minecraft/world/level/Level;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "syncId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "startOpen", "user", "Lnet/minecraft/world/entity/ContainerUser;", "stopOpen", "triggerEvent", "", "id", "type", "updateNeighbours", "canPlaceItem", "slot", "stack", "Lnet/minecraft/world/item/ItemStack;", "Companion", "ellsso-neoforge-1.21.10"})
public final class ShulkerBoxBlockEntity
extends InventoryBlockEntity
implements LidBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DyeColor color;
    @NotNull
    private LidController lidController;
    @NotNull
    private final ContainerOpenersCounter openersCounter;

    public ShulkerBoxBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(ModBlockEntities.INSTANCE.getSHULKER_BOX(), pos, state);
        Block block = state.getBlock();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type moi.ellie.storageoptions.block.ShulkerBoxBlock");
        this.color = ((ShulkerBoxBlock)block).getColor();
        this.lidController = new LidController(){

            public void onLidOpenMore(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Direction openDirection = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                AABB changedBoundingBox = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)openDirection, (float)this.getOldOpenness(), (float)this.getOpenness(), (Vec3)Vec3.atBottomCenterOf((Vec3i)((Vec3i)pos)));
                List entities = level.getEntities(null, changedBoundingBox);
                Vec3 force = new Vec3(new Vector3d(changedBoundingBox.getXsize(), changedBoundingBox.getYsize(), changedBoundingBox.getZsize()).add(0.01, 0.01, 0.01).mul((Vector3fc)openDirection.step()).get(new Vector3f()));
                for (Entity entity : entities) {
                    if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                    entity.move(MoverType.SHULKER_BOX, force);
                }
            }

            public void onAnimationStateChanged(Level level, BlockPos pos, BlockState state, LidController.AnimationState animation) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)((Object)animation), (String)"animation");
                state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
                level.updateNeighborsAt(pos, state.getBlock());
            }
        };
        this.openersCounter = new ContainerOpenersCounter(this){
            final /* synthetic */ ShulkerBoxBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                level.playSound(null, this.this$0.getBlockPos(), SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                level.playSound(null, this.this$0.getBlockPos(), SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int oldCount, int count) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                level.blockEvent(pos, state.getBlock(), 2, count);
            }

            public boolean isOwnContainer(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                ShulkerBoxMenu shulkerBoxMenu = abstractContainerMenu instanceof ShulkerBoxMenu ? (ShulkerBoxMenu)abstractContainerMenu : null;
                return Intrinsics.areEqual((Object)(shulkerBoxMenu != null ? shulkerBoxMenu.container : null), (Object)((Object)this));
            }
        };
    }

    @Nullable
    public final DyeColor getColor() {
        return this.color;
    }

    @NotNull
    public final LidController getLidController() {
        return this.lidController;
    }

    public final void setLidController(@NotNull LidController lidController2) {
        Intrinsics.checkNotNullParameter((Object)lidController2, (String)"<set-?>");
        this.lidController = lidController2;
    }

    @NotNull
    public final ContainerOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.shulkerBox");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public float getOpenNess(float partialTicks) {
        return this.lidController.getOpenNess(partialTicks);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public final void updateAnimation(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.lidController.tickLid(level, pos, state);
    }

    @Override
    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        return (AbstractContainerMenu)new ShulkerBoxMenu(syncId, playerInventory, (Container)this);
    }

    public void startOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        this.openersCounter.incrementOpeners(user.getLivingEntity(), level2, this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
    }

    public void stopOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        this.openersCounter.decrementOpeners(user.getLivingEntity(), level2, this.getBlockPos(), this.getBlockState());
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 2) {
            this.lidController.setOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public final void updateNeighbours() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        this.getBlockState().updateNeighbourShapes((LevelAccessor)level2, this.getBlockPos(), 3);
        level2.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.getItem().canFitInsideContainerItems();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lmoi/ellie/storageoptions/block/entity/ShulkerBoxBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "entity", "Lmoi/ellie/storageoptions/block/entity/ShulkerBoxBlockEntity;", "isClosed", "", "Lnet/minecraft/world/level/BlockGetter;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ShulkerBoxBlockEntity entity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            entity.updateAnimation(level, pos, state);
        }

        public final boolean isClosed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Boolean bl = level.getBlockEntity(pos, ModBlockEntities.INSTANCE.getSHULKER_BOX()).map(arg_0 -> Companion.isClosed$lambda$1(Companion::isClosed$lambda$0, arg_0)).orElse(true);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
            return bl;
        }

        private static final Boolean isClosed$lambda$0(ShulkerBoxBlockEntity entity) {
            return entity.getLidController().getAnimationState() == LidController.AnimationState.CLOSED;
        }

        private static final Boolean isClosed$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

