/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.TallBarrelBlock;
import moi.ellie.storageoptions.block.entity.DoubleInventoryBlockEntity;
import moi.ellie.storageoptions.block.misc.BarrelType;
import moi.ellie.storageoptions.block.misc.CachedDoubleBlock;
import moi.ellie.storageoptions.registration.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lmoi/ellie/storageoptions/block/entity/TallBarrelBlockEntity;", "Lmoi/ellie/storageoptions/block/entity/DoubleInventoryBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "openersCounter", "Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "startOpen", "", "user", "Lnet/minecraft/world/entity/ContainerUser;", "stopOpen", "recheckOpen", "ensureDoubleCache", "Lmoi/ellie/storageoptions/block/misc/CachedDoubleBlock;", "areStatesMeaningfullyDifferent", "", "first", "second", "isSingleState", "Companion", "ellsso-neoforge-1.21.10"})
public final class TallBarrelBlockEntity
extends DoubleInventoryBlockEntity<TallBarrelBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContainerOpenersCounter openersCounter;

    public TallBarrelBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(ModBlockEntities.INSTANCE.getBARREL(), pos, state);
        this.openersCounter = new ContainerOpenersCounter(this){
            final /* synthetic */ TallBarrelBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (state.getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE()) != BarrelType.BOTTOM) {
                    SoundEvent soundEvent = SoundEvents.BARREL_OPEN;
                    Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BARREL_OPEN");
                    TallBarrelBlockEntity.Companion.playLidSound(level, state, pos, soundEvent);
                    TallBarrelBlockEntity.Companion.updateOpenState(level, state, pos, true);
                }
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (state.getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE()) != BarrelType.BOTTOM) {
                    SoundEvent soundEvent = SoundEvents.BARREL_CLOSE;
                    Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BARREL_CLOSE");
                    TallBarrelBlockEntity.Companion.playLidSound(level, state, pos, soundEvent);
                    TallBarrelBlockEntity.Companion.updateOpenState(level, state, pos, false);
                }
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            }

            public boolean isOwnContainer(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                ChestMenu chestMenu = abstractContainerMenu instanceof ChestMenu ? (ChestMenu)abstractContainerMenu : null;
                if (chestMenu == null) {
                    return false;
                }
                Container container = chestMenu.getContainer();
                return container == this.this$0 || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)this.this$0);
            }
        };
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.barrel");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public void startOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        LivingEntity livingEntity = user.getLivingEntity();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        this.openersCounter.incrementOpeners(livingEntity, level, this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
    }

    public void stopOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (this.isRemoved() || user.getLivingEntity().isSpectator()) {
            return;
        }
        LivingEntity livingEntity = user.getLivingEntity();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        this.openersCounter.decrementOpeners(livingEntity, level, this.getBlockPos(), this.getBlockState());
    }

    public final void recheckOpen() {
        if (this.isRemoved()) {
            return;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        this.openersCounter.recheckOpeners(level, this.getBlockPos(), this.getBlockState());
    }

    @Override
    @Nullable
    protected CachedDoubleBlock<TallBarrelBlockEntity> ensureDoubleCache() {
        BarrelType barrelType = (BarrelType)((Object)this.getBlockState().getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE()));
        if (barrelType != BarrelType.SINGLE) {
            TallBarrelBlockEntity otherEntity;
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            BlockPos blockPos = this.getBlockPos();
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Direction direction = TallBarrelBlock.Companion.getConnectedDirection(blockState);
            Intrinsics.checkNotNull((Object)direction);
            BlockEntity blockEntity = level.getBlockEntity(blockPos.relative(direction));
            TallBarrelBlockEntity tallBarrelBlockEntity = otherEntity = blockEntity instanceof TallBarrelBlockEntity ? (TallBarrelBlockEntity)blockEntity : null;
            if (otherEntity != null) {
                CachedDoubleBlock<DoubleInventoryBlockEntity> doubleCache = barrelType == BarrelType.TOP ? new CachedDoubleBlock<DoubleInventoryBlockEntity>(this, otherEntity) : new CachedDoubleBlock<DoubleInventoryBlockEntity>(otherEntity, this);
                ((TallBarrelBlockEntity)doubleCache.getFirst()).setDoubleCache$ellsso_neoforge_1_21_10(doubleCache);
                ((TallBarrelBlockEntity)doubleCache.getSecond()).setDoubleCache$ellsso_neoforge_1_21_10(doubleCache);
                return doubleCache;
            }
        }
        return null;
    }

    @Override
    protected boolean areStatesMeaningfullyDifferent(@NotNull BlockState first, @NotNull BlockState second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return first.getValue((Property)BlockStateProperties.FACING) != second.getValue((Property)BlockStateProperties.FACING) || first.getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE()) != second.getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE());
    }

    @Override
    protected boolean isSingleState(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.getValue((Property)TallBarrelBlock.Companion.getBARREL_TYPE()) == BarrelType.SINGLE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lmoi/ellie/storageoptions/block/entity/TallBarrelBlockEntity$Companion;", "", "<init>", "()V", "updateOpenState", "", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "open", "", "playLidSound", "sound", "Lnet/minecraft/sounds/SoundEvent;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateOpenState(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, boolean open) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }

        public final void playLidSound(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull SoundEvent sound) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            Vec3 lidPos = pos.getCenter().relative((Direction)state.getValue((Property)BlockStateProperties.FACING), 0.5);
            float pitch = level.random.nextFloat() * 0.1f + 0.9f;
            level.playSound(null, lidPos.x, lidPos.y, lidPos.z, sound, SoundSource.BLOCKS, 0.5f, pitch);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

