/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.menu;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.registration.ModMenus;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lmoi/ellie/storageoptions/block/menu/MiniChestMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "syncId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "container", "Lnet/minecraft/world/Container;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;)V", "(ILnet/minecraft/world/entity/player/Inventory;)V", "getContainer", "()Lnet/minecraft/world/Container;", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "slot", "stillValid", "", "ellsso-neoforge-1.21.10"})
public final class MiniChestMenu
extends AbstractContainerMenu {
    @NotNull
    private final Container container;

    public MiniChestMenu(int syncId, @NotNull Inventory playerInventory, @NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(ModMenus.INSTANCE.getMINI_CHEST(), syncId);
        this.container = container;
        this.container.startOpen((ContainerUser)playerInventory.player);
        this.addSlot(new Slot(this.container, 0, 80, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, y * 18 + 84));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, 142));
        }
    }

    @NotNull
    public final Container getContainer() {
        return this.container;
    }

    public MiniChestMenu(int syncId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this(syncId, playerInventory, (Container)new SimpleContainer(1));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (slot >= this.slots.size()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        Object object = this.slots.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot target = (Slot)object;
        if (!target.hasItem()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack stackInSlot = target.getItem();
        ItemStack copy = stackInSlot.copy();
        if (slot == 0) {
            if (!this.moveItemStackTo(stackInSlot, this.container.getContainerSize(), this.slots.size(), true)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (!this.moveItemStackTo(stackInSlot, 0, this.container.getContainerSize(), false)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (stackInSlot.isEmpty()) {
            target.setByPlayer(ItemStack.EMPTY);
        } else {
            target.setChanged();
        }
        Intrinsics.checkNotNull((Object)copy);
        return copy;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.container.stillValid(player);
    }
}

