/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.block.misc;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lmoi/ellie/storageoptions/block/misc/LidController;", "", "<init>", "()V", "shouldBeOpen", "", "openness", "", "getOpenness", "()F", "setOpenness", "(F)V", "oldOpenness", "getOldOpenness", "setOldOpenness", "animation", "Lmoi/ellie/storageoptions/block/misc/LidController$AnimationState;", "onAnimationStateChanged", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "onLidOpenMore", "tickLid", "getOpenNess", "partialTicks", "setOpen", "getAnimationState", "AnimationState", "ellsso-neoforge-1.21.10"})
public class LidController {
    private boolean shouldBeOpen;
    private float openness;
    private float oldOpenness;
    @NotNull
    private AnimationState animation = AnimationState.CLOSED;

    protected final float getOpenness() {
        return this.openness;
    }

    protected final void setOpenness(float f) {
        this.openness = f;
    }

    protected final float getOldOpenness() {
        return this.oldOpenness;
    }

    protected final void setOldOpenness(float f) {
        this.oldOpenness = f;
    }

    public void onAnimationStateChanged(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull AnimationState animation) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)animation), (String)"animation");
    }

    public void onLidOpenMore(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public final void tickLid(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.oldOpenness = this.openness;
        switch (WhenMappings.$EnumSwitchMapping$0[this.animation.ordinal()]) {
            case 1: {
                if (!this.shouldBeOpen) break;
                this.animation = AnimationState.OPENING;
                this.onAnimationStateChanged(level, pos, state, this.animation);
                break;
            }
            case 2: {
                if (this.shouldBeOpen) {
                    this.openness += 0.1f;
                    this.onLidOpenMore(level, pos, state);
                    if (!(this.openness >= 1.0f)) break;
                    this.openness = 1.0f;
                    this.animation = AnimationState.OPENED;
                    this.onAnimationStateChanged(level, pos, state, this.animation);
                    break;
                }
                this.animation = AnimationState.CLOSING;
                break;
            }
            case 3: {
                if (this.shouldBeOpen) break;
                this.animation = AnimationState.CLOSING;
                this.onAnimationStateChanged(level, pos, state, this.animation);
                break;
            }
            case 4: {
                if (this.shouldBeOpen) {
                    this.animation = AnimationState.OPENING;
                    break;
                }
                this.openness -= 0.1f;
                if (!(this.openness <= 0.0f)) break;
                this.openness = 0.0f;
                this.animation = AnimationState.CLOSED;
                this.onAnimationStateChanged(level, pos, state, this.animation);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final float getOpenNess(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oldOpenness, (float)this.openness);
    }

    public final void setOpen(boolean shouldBeOpen) {
        this.shouldBeOpen = shouldBeOpen;
    }

    @NotNull
    public final AnimationState getAnimationState() {
        return this.animation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lmoi/ellie/storageoptions/block/misc/LidController$AnimationState;", "", "<init>", "(Ljava/lang/String;I)V", "CLOSED", "OPENING", "OPENED", "CLOSING", "ellsso-neoforge-1.21.10"})
    public static final class AnimationState
    extends Enum<AnimationState> {
        public static final /* enum */ AnimationState CLOSED = new AnimationState();
        public static final /* enum */ AnimationState OPENING = new AnimationState();
        public static final /* enum */ AnimationState OPENED = new AnimationState();
        public static final /* enum */ AnimationState CLOSING = new AnimationState();
        private static final /* synthetic */ AnimationState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AnimationState[] values() {
            return (AnimationState[])$VALUES.clone();
        }

        public static AnimationState valueOf(String value) {
            return Enum.valueOf(AnimationState.class, value);
        }

        @NotNull
        public static EnumEntries<AnimationState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = animationStateArray = new AnimationState[]{AnimationState.CLOSED, AnimationState.OPENING, AnimationState.OPENED, AnimationState.CLOSING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnimationState.values().length];
            try {
                nArray[AnimationState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimationState.OPENING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimationState.OPENED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimationState.CLOSING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

