/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.client.model;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import moi.ellie.storageoptions.EllsSO;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;", "Lnet/minecraft/client/model/Model;", "", "model", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "lid", "setupAnim", "", "openness", "Companion", "ellsso-neoforge-1.21.10"})
@SourceDebugExtension(value={"SMAP\nShulkerBoxModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShulkerBoxModel.kt\nmoi/ellie/storageoptions/client/model/ShulkerBoxModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1285#2,2:59\n1299#2,4:61\n*S KotlinDebug\n*F\n+ 1 ShulkerBoxModel.kt\nmoi/ellie/storageoptions/client/model/ShulkerBoxModel\n*L\n28#1:59,2\n28#1:61,4\n*E\n"})
public final class ShulkerBoxModel
extends Model<Float> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ModelPart lid;
    @NotNull
    private static final Material DEFAULT_SHULKER_MATERIAL;
    @NotNull
    private static final Map<DyeColor, Material> DYED_SHULKER_MATERIALS;
    @NotNull
    private static final ModelLayerLocation MODEL_LAYER;

    public ShulkerBoxModel(@NotNull ModelPart model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model, RenderType::entityCutoutNoCull);
        ModelPart modelPart = model.getChild("lid");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.lid = modelPart;
    }

    public void setupAnim(float openness) {
        this.lid.setPos(0.0f, 12.0f + 8.0f * openness, 0.0f);
        this.lid.yRot = -270.0f * openness * ((float)Math.PI / 180);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateWithTo$iv$iv;
        Companion = new Companion(null);
        DEFAULT_SHULKER_MATERIAL = new Material(Sheets.SHULKER_SHEET, EllsSO.INSTANCE.id("entity/shulker/shulker_box"));
        Iterable $this$associateWith$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            DyeColor dyeColor = (DyeColor)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Material material = new Material(Sheets.SHULKER_SHEET, EllsSO.INSTANCE.id("entity/shulker/" + it.getSerializedName() + "_shulker_box"));
            map.put(t, material);
        }
        DYED_SHULKER_MATERIALS = destination$iv$iv;
        MODEL_LAYER = new ModelLayerLocation(EllsSO.INSTANCE.id("shulker_box"), "main");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel$Companion;", "", "<init>", "()V", "DEFAULT_SHULKER_MATERIAL", "Lnet/minecraft/client/resources/model/Material;", "getDEFAULT_SHULKER_MATERIAL", "()Lnet/minecraft/client/resources/model/Material;", "DYED_SHULKER_MATERIALS", "", "Lnet/minecraft/world/item/DyeColor;", "getDYED_SHULKER_MATERIALS", "()Ljava/util/Map;", "MODEL_LAYER", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getMODEL_LAYER", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "getMaterial", "color", "ellsso-neoforge-1.21.10"})
    @SourceDebugExtension(value={"SMAP\nShulkerBoxModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShulkerBoxModel.kt\nmoi/ellie/storageoptions/client/model/ShulkerBoxModel$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Material getDEFAULT_SHULKER_MATERIAL() {
            return DEFAULT_SHULKER_MATERIAL;
        }

        @NotNull
        public final Map<DyeColor, Material> getDYED_SHULKER_MATERIALS() {
            return DYED_SHULKER_MATERIALS;
        }

        @NotNull
        public final ModelLayerLocation getMODEL_LAYER() {
            return MODEL_LAYER;
        }

        @NotNull
        public final LayerDefinition createLayer() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.getRoot().addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 28).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 8.0f, 16.0f), PartPose.ZERO);
            mesh.getRoot().addOrReplaceChild("lid", CubeListBuilder.create().addBox(-8.0f, -16.0f, -8.0f, 16.0f, 12.0f, 16.0f), PartPose.ZERO);
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        @NotNull
        public final Material getMaterial(@Nullable DyeColor color) {
            DyeColor dyeColor;
            block3: {
                block2: {
                    dyeColor = color;
                    if (dyeColor == null) break block2;
                    DyeColor it = dyeColor;
                    boolean bl = false;
                    Material material = Companion.getDYED_SHULKER_MATERIALS().get(it);
                    Intrinsics.checkNotNull((Object)material);
                    dyeColor = material;
                    if (material != null) break block3;
                }
                dyeColor = this.getDEFAULT_SHULKER_MATERIAL();
            }
            return dyeColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
        }
    }
}

