/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.ClassicChestBlock;
import moi.ellie.storageoptions.block.entity.ChestBlockEntity;
import moi.ellie.storageoptions.block.misc.CachedDoubleBlock;
import moi.ellie.storageoptions.block.misc.ChestType;
import moi.ellie.storageoptions.client.model.ChestModel;
import moi.ellie.storageoptions.client.render.ChestRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J(\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006%"}, d2={"Lmoi/ellie/storageoptions/client/render/ChestBlockRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lmoi/ellie/storageoptions/block/entity/ChestBlockEntity;", "Lmoi/ellie/storageoptions/client/render/ChestRenderState;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "materials", "Lnet/minecraft/client/resources/model/MaterialSet;", "kotlin.jvm.PlatformType", "singleModel", "Lmoi/ellie/storageoptions/client/model/ChestModel;", "getSingleModel", "()Lmoi/ellie/storageoptions/client/model/ChestModel;", "leftModel", "getLeftModel", "rightModel", "getRightModel", "extractRenderState", "", "entity", "renderState", "partialTick", "", "cameraPos", "Lnet/minecraft/world/phys/Vec3;", "crumblingOverlay", "Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;", "submit", "poses", "Lcom/mojang/blaze3d/vertex/PoseStack;", "output", "Lnet/minecraft/client/renderer/SubmitNodeCollector;", "camera", "Lnet/minecraft/client/renderer/state/CameraRenderState;", "createRenderState", "ellsso-neoforge-1.21.10"})
public final class ChestBlockRenderer
implements BlockEntityRenderer<ChestBlockEntity, ChestRenderState> {
    private final MaterialSet materials;
    @NotNull
    private final ChestModel singleModel;
    @NotNull
    private final ChestModel leftModel;
    @NotNull
    private final ChestModel rightModel;

    public ChestBlockRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.materials = context.materials();
        ModelPart modelPart = context.bakeLayer(ChestModel.Companion.getSINGLE_MODEL_LAYER());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.singleModel = new ChestModel(modelPart);
        ModelPart modelPart2 = context.bakeLayer(ChestModel.Companion.getLEFT_MODEL_LAYER());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.leftModel = new ChestModel(modelPart2);
        ModelPart modelPart3 = context.bakeLayer(ChestModel.Companion.getRIGHT_MODEL_LAYER());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"bakeLayer(...)");
        this.rightModel = new ChestModel(modelPart3);
    }

    @NotNull
    public final ChestModel getSingleModel() {
        return this.singleModel;
    }

    @NotNull
    public final ChestModel getLeftModel() {
        return this.leftModel;
    }

    @NotNull
    public final ChestModel getRightModel() {
        return this.rightModel;
    }

    public void extractRenderState(@NotNull ChestBlockEntity entity, @NotNull ChestRenderState renderState, float partialTick, @NotNull Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        BlockState state = entity.getBlockState();
        Comparable comparable = state.getValue((Property)ClassicChestBlock.Companion.getCHEST_TYPE());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        renderState.setChestType((ChestType)((Object)comparable));
        Comparable comparable2 = state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getValue(...)");
        renderState.setFacing((Direction)comparable2);
        Holder.Reference reference = state.getBlock().builtInRegistryHolder();
        Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"builtInRegistryHolder(...)");
        renderState.setMaterial(ChestModel.Companion.getTexture(reference, renderState.getChestType()));
        CachedDoubleBlock doubleCache = entity.getDoubleCache();
        if (doubleCache != null) {
            renderState.setLidAngle(((Number)doubleCache.calculate((arg_0, arg_1) -> ChestBlockRenderer.extractRenderState$lambda$0(partialTick, arg_0, arg_1))).floatValue());
            renderState.lightCoords = ((Number)doubleCache.calculate(ChestBlockRenderer::extractRenderState$lambda$1)).intValue();
        } else {
            renderState.setLidAngle(entity.getOpenNess(partialTick));
        }
    }

    public void submit(@NotNull ChestRenderState renderState, @NotNull PoseStack poses, @NotNull SubmitNodeCollector output, @NotNull CameraRenderState camera) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)poses, (String)"poses");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        poses.pushPose();
        ChestModel model = switch (WhenMappings.$EnumSwitchMapping$0[renderState.getChestType().ordinal()]) {
            case 1 -> this.singleModel;
            case 2 -> this.leftModel;
            case 3 -> this.rightModel;
            default -> throw new NoWhenBranchMatchedException();
        };
        poses.translate(0.5f, 0.0f, 0.5f);
        poses.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.getFacing().toYRot()));
        model.setupAnim(renderState.getLidAngle());
        output.submitModel((Model)model, (Object)Float.valueOf(renderState.getLidAngle()), poses, renderState.getMaterial().renderType(RenderType::entityCutout), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materials.get(renderState.getMaterial()), 0, renderState.breakProgress);
        poses.popPose();
    }

    @NotNull
    public ChestRenderState createRenderState() {
        return new ChestRenderState();
    }

    private static final float extractRenderState$lambda$0(float $partialTick, ChestBlockEntity first, ChestBlockEntity second) {
        Intrinsics.checkNotNullParameter((Object)((Object)first), (String)"first");
        Intrinsics.checkNotNullParameter((Object)((Object)second), (String)"second");
        return Math.max(first.getOpenNess($partialTick), second.getOpenNess($partialTick));
    }

    private static final int extractRenderState$lambda$1(ChestBlockEntity first, ChestBlockEntity second) {
        Intrinsics.checkNotNullParameter((Object)((Object)first), (String)"first");
        Intrinsics.checkNotNullParameter((Object)((Object)second), (String)"second");
        Level level = first.getLevel();
        Intrinsics.checkNotNull((Object)level);
        int firstLightColor = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)level), (BlockPos)first.getBlockPos());
        int firstBlockLight = LightTexture.block((int)firstLightColor);
        int firstSkyLight = LightTexture.sky((int)firstLightColor);
        Level level2 = second.getLevel();
        Intrinsics.checkNotNull((Object)level2);
        int secondLightColor = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)level2), (BlockPos)second.getBlockPos());
        int secondBlockLight = LightTexture.block((int)secondLightColor);
        int secondSkyLight = LightTexture.sky((int)secondLightColor);
        return LightTexture.pack((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChestType.values().length];
            try {
                nArray[ChestType.SINGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChestType.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChestType.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

