/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty1;
import moi.ellie.storageoptions.client.model.ShulkerBoxModel;
import moi.ellie.storageoptions.client.render.ShulkerBoxItemModelRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0016\u0010\"\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lmoi/ellie/storageoptions/client/render/ShulkerBoxItemModelRenderer;", "Lnet/minecraft/client/renderer/special/NoDataSpecialModelRenderer;", "model", "Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;", "materials", "Lnet/minecraft/client/resources/model/MaterialSet;", "material", "Lnet/minecraft/client/resources/model/Material;", "openness", "", "<init>", "(Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;Lnet/minecraft/client/resources/model/MaterialSet;Lnet/minecraft/client/resources/model/Material;F)V", "getModel", "()Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;", "getMaterials", "()Lnet/minecraft/client/resources/model/MaterialSet;", "getMaterial", "()Lnet/minecraft/client/resources/model/Material;", "getOpenness", "()F", "submit", "", "context", "Lnet/minecraft/world/item/ItemDisplayContext;", "poses", "Lcom/mojang/blaze3d/vertex/PoseStack;", "output", "Lnet/minecraft/client/renderer/SubmitNodeCollector;", "light", "", "overlay", "enchanted", "", "outlineColor", "getExtents", "vertices", "", "Lorg/joml/Vector3f;", "Unbaked", "ellsso-neoforge-1.21.10"})
public final class ShulkerBoxItemModelRenderer
implements NoDataSpecialModelRenderer {
    @NotNull
    private final ShulkerBoxModel model;
    @NotNull
    private final MaterialSet materials;
    @NotNull
    private final Material material;
    private final float openness;

    public ShulkerBoxItemModelRenderer(@NotNull ShulkerBoxModel model, @NotNull MaterialSet materials, @NotNull Material material, float openness) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)materials, (String)"materials");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        this.model = model;
        this.materials = materials;
        this.material = material;
        this.openness = openness;
    }

    @NotNull
    public final ShulkerBoxModel getModel() {
        return this.model;
    }

    @NotNull
    public final MaterialSet getMaterials() {
        return this.materials;
    }

    @NotNull
    public final Material getMaterial() {
        return this.material;
    }

    public final float getOpenness() {
        return this.openness;
    }

    public void submit(@NotNull ItemDisplayContext context, @NotNull PoseStack poses, @NotNull SubmitNodeCollector output, int light, int overlay, boolean enchanted, int outlineColor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)poses, (String)"poses");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        poses.pushPose();
        poses.translate(0.5f, 0.5f, 0.5f);
        output.submitModel((Model)this.model, (Object)Float.valueOf(this.openness), poses, this.material.renderType(RenderType::entityCutoutNoCullZOffset), light, overlay, -1, this.materials.get(this.material), 0, null);
        poses.popPose();
    }

    public void getExtents(@NotNull Set<? extends Vector3f> vertices) {
        Intrinsics.checkNotNullParameter(vertices, (String)"vertices");
        PoseStack poses = new PoseStack();
        this.model.setupAnim(this.openness);
        this.model.root().getExtentsForGui(poses, vertices);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lmoi/ellie/storageoptions/client/render/ShulkerBoxItemModelRenderer$Unbaked;", "Lnet/minecraft/client/renderer/special/SpecialModelRenderer$Unbaked;", "color", "Ljava/util/Optional;", "Lnet/minecraft/world/item/DyeColor;", "openness", "", "<init>", "(Ljava/util/Optional;F)V", "(Lnet/minecraft/world/item/DyeColor;F)V", "getColor", "()Ljava/util/Optional;", "getOpenness", "()F", "bake", "Lnet/minecraft/client/renderer/special/SpecialModelRenderer;", "context", "Lnet/minecraft/client/renderer/special/SpecialModelRenderer$BakingContext;", "type", "Lcom/mojang/serialization/MapCodec;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "ellsso-neoforge-1.21.10"})
    public static final class Unbaked
    implements SpecialModelRenderer.Unbaked {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Optional<DyeColor> color;
        private final float openness;
        @NotNull
        private static final MapCodec<Unbaked> CODEC;

        public Unbaked(@NotNull Optional<DyeColor> color, float openness) {
            Intrinsics.checkNotNullParameter(color, (String)"color");
            this.color = color;
            this.openness = openness;
        }

        @NotNull
        public final Optional<DyeColor> getColor() {
            return this.color;
        }

        public final float getOpenness() {
            return this.openness;
        }

        public Unbaked(@Nullable DyeColor color, float openness) {
            Optional<DyeColor> optional = Optional.ofNullable(color);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            this(optional, openness);
        }

        @NotNull
        public SpecialModelRenderer<?> bake(@NotNull SpecialModelRenderer.BakingContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ModelPart modelPart = context.entityModelSet().bakeLayer(ShulkerBoxModel.Companion.getMODEL_LAYER());
            Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
            ShulkerBoxModel shulkerBoxModel = new ShulkerBoxModel(modelPart);
            MaterialSet materialSet = context.materials();
            Intrinsics.checkNotNullExpressionValue((Object)materialSet, (String)"materials(...)");
            return (SpecialModelRenderer)new ShulkerBoxItemModelRenderer(shulkerBoxModel, materialSet, ShulkerBoxModel.Companion.getMaterial((DyeColor)OptionalsKt.getOrNull(this.color)), this.openness);
        }

        @NotNull
        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return CODEC;
        }

        @NotNull
        public final Optional<DyeColor> component1() {
            return this.color;
        }

        public final float component2() {
            return this.openness;
        }

        @NotNull
        public final Unbaked copy(@NotNull Optional<DyeColor> color, float openness) {
            Intrinsics.checkNotNullParameter(color, (String)"color");
            return new Unbaked(color, openness);
        }

        public static /* synthetic */ Unbaked copy$default(Unbaked unbaked, Optional optional, float f, int n, Object object) {
            if ((n & 1) != 0) {
                optional = unbaked.color;
            }
            if ((n & 2) != 0) {
                f = unbaked.openness;
            }
            return unbaked.copy(optional, f);
        }

        @NotNull
        public String toString() {
            return "Unbaked(color=" + this.color + ", openness=" + this.openness + ")";
        }

        public int hashCode() {
            int result = this.color.hashCode();
            result = result * 31 + Float.hashCode(this.openness);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unbaked)) {
                return false;
            }
            Unbaked unbaked = (Unbaked)other;
            if (!Intrinsics.areEqual(this.color, unbaked.color)) {
                return false;
            }
            return Float.compare(this.openness, unbaked.openness) == 0;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(arg_0 -> Unbaked.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.FLOAT.optionalFieldOf("openness", (Object)Float.valueOf(0.0f)).forGetter(arg_0 -> Unbaked.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, Unbaked::new);
        }

        private static final Optional CODEC$lambda$0$0(KProperty1 $tmp0, Unbaked p0) {
            return (Optional)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Float CODEC$lambda$0$1(KProperty1 $tmp0, Unbaked p0) {
            return (Float)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Unbaked::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lmoi/ellie/storageoptions/client/render/ShulkerBoxItemModelRenderer$Unbaked$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lmoi/ellie/storageoptions/client/render/ShulkerBoxItemModelRenderer$Unbaked;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "ellsso-neoforge-1.21.10"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<Unbaked> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

