/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.block.entity.ShulkerBoxBlockEntity;
import moi.ellie.storageoptions.client.model.ShulkerBoxModel;
import moi.ellie.storageoptions.client.render.ShulkerBoxRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lmoi/ellie/storageoptions/client/render/ShulkerBoxRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lmoi/ellie/storageoptions/block/entity/ShulkerBoxBlockEntity;", "Lmoi/ellie/storageoptions/client/render/ShulkerBoxRenderState;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "materials", "Lnet/minecraft/client/resources/model/MaterialSet;", "kotlin.jvm.PlatformType", "model", "Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;", "getModel", "()Lmoi/ellie/storageoptions/client/model/ShulkerBoxModel;", "extractRenderState", "", "entity", "renderState", "partialTick", "", "cameraPos", "Lnet/minecraft/world/phys/Vec3;", "crumblingOverlay", "Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;", "submit", "poses", "Lcom/mojang/blaze3d/vertex/PoseStack;", "output", "Lnet/minecraft/client/renderer/SubmitNodeCollector;", "camera", "Lnet/minecraft/client/renderer/state/CameraRenderState;", "createRenderState", "ellsso-neoforge-1.21.10"})
public final class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity, ShulkerBoxRenderState> {
    private final MaterialSet materials;
    @NotNull
    private final ShulkerBoxModel model;

    public ShulkerBoxRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.materials = context.materials();
        ModelPart modelPart = context.bakeLayer(ShulkerBoxModel.Companion.getMODEL_LAYER());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new ShulkerBoxModel(modelPart);
    }

    @NotNull
    public final ShulkerBoxModel getModel() {
        return this.model;
    }

    public void extractRenderState(@NotNull ShulkerBoxBlockEntity entity, @NotNull ShulkerBoxRenderState renderState, float partialTick, @NotNull Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        Comparable comparable = entity.getBlockState().getValue((Property)BlockStateProperties.FACING);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        renderState.setFacing((Direction)comparable);
        renderState.setOpenness(entity.getOpenNess(partialTick));
        renderState.setMaterial(ShulkerBoxModel.Companion.getMaterial(entity.getColor()));
    }

    public void submit(@NotNull ShulkerBoxRenderState renderState, @NotNull PoseStack poses, @NotNull SubmitNodeCollector output, @NotNull CameraRenderState camera) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)poses, (String)"poses");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        poses.pushPose();
        poses.translate(0.5f, 0.5f, 0.5f);
        poses.mulPose((Quaternionfc)renderState.getFacing().getRotation());
        poses.scale(0.9995f, 0.9995f, 0.9995f);
        this.model.setupAnim(renderState.getOpenness());
        output.submitModel((Model)this.model, (Object)Float.valueOf(renderState.getOpenness()), poses, renderState.getMaterial().renderType(RenderType::entityCutoutNoCullZOffset), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materials.get(renderState.getMaterial()), 0, renderState.breakProgress);
        poses.popPose();
    }

    @NotNull
    public ShulkerBoxRenderState createRenderState() {
        return new ShulkerBoxRenderState();
    }
}

