/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.registration.ModBlocks;
import moi.ellie.storageoptions.registration.ModItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lmoi/ellie/storageoptions/entity/ChestMinecartEntity;", "Lnet/minecraft/world/entity/vehicle/AbstractMinecartContainer;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "displayBlock", "Lnet/minecraft/world/level/block/Block;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/Block;)V", "getDisplayBlock", "()Lnet/minecraft/world/level/block/Block;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "getDropItem", "Lnet/minecraft/world/item/Item;", "getPickResult", "Lnet/minecraft/world/item/ItemStack;", "getContainerSize", "getDefaultDisplayBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getDefaultDisplayOffset", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "stopOpen", "", "user", "Lnet/minecraft/world/entity/ContainerUser;", "ellsso-neoforge-1.21.10"})
public final class ChestMinecartEntity
extends AbstractMinecartContainer {
    @NotNull
    private final Block displayBlock;

    public ChestMinecartEntity(@NotNull EntityType<ChestMinecartEntity> entityType, @NotNull Level level, @NotNull Block displayBlock) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)displayBlock, (String)"displayBlock");
        super(entityType, level);
        this.displayBlock = displayBlock;
    }

    @NotNull
    public final Block getDisplayBlock() {
        return this.displayBlock;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        ChestMenu chestMenu = ChestMenu.threeRows((int)id, (Inventory)playerInventory, (Container)((Container)this));
        Intrinsics.checkNotNullExpressionValue((Object)chestMenu, (String)"threeRows(...)");
        return (AbstractContainerMenu)chestMenu;
    }

    @NotNull
    protected Item getDropItem() {
        Item item;
        Block block = this.displayBlock;
        if (Intrinsics.areEqual((Object)block, (Object)((Object)ModBlocks.INSTANCE.getCLASSIC_CHEST()))) {
            item = ModItems.INSTANCE.getCLASSIC_CHEST_MINECART();
        } else if (Intrinsics.areEqual((Object)block, (Object)((Object)ModBlocks.INSTANCE.getOAK_CHEST()))) {
            item = ModItems.INSTANCE.getOAK_CHEST_MINECART();
        } else if (Intrinsics.areEqual((Object)block, (Object)((Object)ModBlocks.INSTANCE.getSPRUCE_CHEST()))) {
            item = ModItems.INSTANCE.getSPRUCE_CHEST_MINECART();
        } else if (Intrinsics.areEqual((Object)block, (Object)((Object)ModBlocks.INSTANCE.getDARK_OAK_CHEST()))) {
            item = ModItems.INSTANCE.getDARK_OAK_CHEST_MINECART();
        } else {
            Item item2 = Items.AIR;
            item = item2;
            Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"AIR");
        }
        return item;
    }

    @NotNull
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public int getContainerSize() {
        return 27;
    }

    @NotNull
    public BlockState getDefaultDisplayBlockState() {
        Object object = this.displayBlock.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    public int getDefaultDisplayOffset() {
        return 8;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResult result = super.interact(player, hand);
        Level level = this.level();
        if (result.consumesAction() && level instanceof ServerLevel) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((ServerLevel)((ServerLevel)level), (Player)player, (boolean)true);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    public void stopOpen(@NotNull ContainerUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.gameEvent((Holder)GameEvent.CONTAINER_CLOSE, (Entity)user.getLivingEntity());
    }
}

