/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.item;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moi.ellie.storageoptions.entity.ChestMinecartEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lmoi/ellie/storageoptions/item/ChestMinecartItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "Lmoi/ellie/storageoptions/entity/ChestMinecartEntity;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/entity/EntityType;)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "Companion", "ellsso-neoforge-1.21.10"})
public final class ChestMinecartItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityType<ChestMinecartEntity> entityType;
    @NotNull
    private static final DefaultDispenseItemBehavior DISPENSER_BEHAVIOUR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior DEFAULT_BEHAVIOUR;
        {
            this.DEFAULT_BEHAVIOUR = new DefaultDispenseItemBehavior();
        }

        public final DefaultDispenseItemBehavior getDEFAULT_BEHAVIOUR() {
            return this.DEFAULT_BEHAVIOUR;
        }

        protected ItemStack execute(BlockSource block, ItemStack item) {
            ChestMinecartEntity entity;
            BlockState belowFrontState;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Direction forward = (Direction)block.state().getValue((Property)BlockStateProperties.FACING);
            Vec3 dispensePos = block.center().add(forward.getUnitVec3().multiply(1.125, 1.0, 1.125));
            BlockPos frontPos = block.pos().relative(forward);
            BlockState frontState = block.level().getBlockState(frontPos);
            double railHeight = 0.0;
            railHeight = -2.0;
            if (BaseRailBlock.isRail((BlockState)frontState)) {
                Block block2 = frontState.getBlock();
                Intrinsics.checkNotNull((Object)block2, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.BaseRailBlock");
                RailShape railShape = (RailShape)frontState.getValue(((BaseRailBlock)block2).getShapeProperty());
                railHeight = railShape.isSlope() ? 0.5 : 0.0;
            } else if (frontState.isAir() && BaseRailBlock.isRail((BlockState)(belowFrontState = block.level().getBlockState(frontPos.below())))) {
                Block block3 = belowFrontState.getBlock();
                Intrinsics.checkNotNull((Object)block3, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.BaseRailBlock");
                RailShape railShape = (RailShape)belowFrontState.getValue(((BaseRailBlock)block3).getShapeProperty());
                railHeight = forward != Direction.DOWN && railShape.isSlope() ? -0.5 : -1.0;
            }
            if (railHeight == -2.0) {
                ItemStack itemStack = this.DEFAULT_BEHAVIOUR.dispense(block, item);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"dispense(...)");
                return itemStack;
            }
            Item item2 = item.getItem();
            Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type moi.ellie.storageoptions.item.ChestMinecartItem");
            ChestMinecartEntity chestMinecartEntity = (ChestMinecartEntity)((ChestMinecartItem)item2).getEntityType().create((Level)block.level(), EntitySpawnReason.DISPENSER);
            if (chestMinecartEntity != null) {
                ChestMinecartEntity chestMinecartEntity2;
                ChestMinecartEntity $this$execute_u24lambda_u240 = chestMinecartEntity2 = chestMinecartEntity;
                boolean bl = false;
                $this$execute_u24lambda_u240.setPos(dispensePos.add(0.0, railHeight + 0.0625, 0.0));
                EntityType.createDefaultStackConfig((Level)((Level)block.level()), (ItemStack)item, null).accept($this$execute_u24lambda_u240);
                v5 = chestMinecartEntity2;
            } else {
                v5 = entity = null;
            }
            if (entity != null) {
                block.level().addFreshEntity((Entity)entity);
                item.shrink(1);
            }
            return item;
        }
    };

    public ChestMinecartItem(@NotNull Item.Properties properties, @NotNull EntityType<ChestMinecartEntity> entityType) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        super(properties);
        this.entityType = entityType;
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)this), (DispenseItemBehavior)((DispenseItemBehavior)DISPENSER_BEHAVIOUR));
    }

    @NotNull
    public final EntityType<ChestMinecartEntity> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (!BaseRailBlock.isRail((BlockState)state)) {
            InteractionResult.Fail fail = InteractionResult.FAIL;
            Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
            return (InteractionResult)fail;
        }
        if (!level.isClientSide()) {
            ChestMinecartEntity entity;
            Block block = state.getBlock();
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.BaseRailBlock");
            RailShape railShape = (RailShape)state.getValue(((BaseRailBlock)block).getShapeProperty());
            double railHeight = railShape.isSlope() ? 0.0 : -0.5;
            Item item = context.getItemInHand().getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type moi.ellie.storageoptions.item.ChestMinecartItem");
            EntityType<ChestMinecartEntity> entityType = ((ChestMinecartItem)item).entityType;
            ChestMinecartEntity chestMinecartEntity = (ChestMinecartEntity)entityType.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            if (chestMinecartEntity != null) {
                ChestMinecartEntity chestMinecartEntity2;
                ChestMinecartEntity $this$useOn_u24lambda_u240 = chestMinecartEntity2 = chestMinecartEntity;
                boolean bl = false;
                $this$useOn_u24lambda_u240.setPos(Vec3.atCenterOf((Vec3i)((Vec3i)pos)).add(0.0, 0.0625 + railHeight, 0.0));
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                EntityType.createDefaultStackConfig((Level)((Level)((ServerLevel)level)), (ItemStack)context.getItemInHand(), (LivingEntity)((LivingEntity)context.getPlayer())).accept($this$useOn_u24lambda_u240);
                v4 = chestMinecartEntity2;
            } else {
                v4 = entity = null;
            }
            if (entity != null) {
                level.addFreshEntity((Entity)entity);
                level.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)((Entity)context.getPlayer()), (BlockState)level.getBlockState(pos.below())));
                context.getItemInHand().shrink(1);
            }
            InteractionResult.Success success = InteractionResult.SUCCESS;
            Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
            return (InteractionResult)success;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lmoi/ellie/storageoptions/item/ChestMinecartItem$Companion;", "", "<init>", "()V", "DISPENSER_BEHAVIOUR", "Lnet/minecraft/core/dispenser/DefaultDispenseItemBehavior;", "getDISPENSER_BEHAVIOUR", "()Lnet/minecraft/core/dispenser/DefaultDispenseItemBehavior;", "ellsso-neoforge-1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DefaultDispenseItemBehavior getDISPENSER_BEHAVIOUR() {
            return DISPENSER_BEHAVIOUR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

