/*
 * Decompiled with CFR 0.152.
 */
package moi.ellie.storageoptions.mixin;

import moi.ellie.storageoptions.block.ClassicChestBlock;
import moi.ellie.storageoptions.block.entity.ChestBlockEntity;
import moi.ellie.storageoptions.client.render.ChestBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.IBlockEntityRendererExtension;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChestBlockRenderer.class})
public abstract class ChestRenderingFix
implements IBlockEntityRendererExtension<ChestBlockEntity> {
    @NotNull
    public AABB getRenderBoundingBox(ChestBlockEntity entity) {
        BlockState state = entity.getBlockState();
        BlockPos pos = entity.getBlockPos();
        Direction connectedDirection = ClassicChestBlock.Companion.getConnectedDirection(state);
        if (connectedDirection == null) {
            return AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)pos));
        }
        return AABB.encapsulatingFullBlocks((BlockPos)pos, (BlockPos)pos.relative(connectedDirection));
    }
}

