/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.lopymine.mossylib.loader.MossyLoader;
import net.lopymine.mossylib.utils.CodecUtils;
import net.lopymine.mossylib.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MossyConfig {
    public static final Codec<MossyConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("mossy", false, Codec.BOOL, MossyConfig::isMossy)).apply((Applicative)instance, MossyConfig::new));
    private static final File CONFIG_FILE = MossyLoader.getConfigDir().resolve("mossylib.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MossyLib/Config");
    private static MossyConfig INSTANCE;
    private boolean mossy;

    private MossyConfig() {
        throw new IllegalArgumentException();
    }

    public static MossyConfig getInstance() {
        return INSTANCE == null ? MossyConfig.reload() : INSTANCE;
    }

    public static MossyConfig reload() {
        INSTANCE = MossyConfig.read();
        return INSTANCE;
    }

    public static MossyConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static MossyConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    @Generated
    public boolean isMossy() {
        return this.mossy;
    }

    @Generated
    public void setMossy(boolean mossy) {
        this.mossy = mossy;
    }

    @Generated
    public MossyConfig(boolean mossy) {
        this.mossy = mossy;
    }
}

