/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.utils;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class DrawUtils {
    public static void drawGuiTexture(GuiGraphics context, ResourceLocation sprite, int x, int y, int width, int height) {
        context.blitSprite(sprite, x, y, width, height);
    }

    public static void drawTexture(GuiGraphics context, ResourceLocation sprite, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        context.blit(sprite, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawTooltip(GuiGraphics context, List<ClientTooltipComponent> list, int x, int y) {
        context.renderTooltipInternal(Minecraft.getInstance().font, list, x, y, DefaultTooltipPositioner.INSTANCE);
    }

    public static void drawCenteredText(GuiGraphics context, int x, int y, int width, Component text) {
        Font textRenderer = Minecraft.getInstance().font;
        int textWidth = textRenderer.width((FormattedText)text);
        int centerX = x + width / 2;
        int start = centerX - textWidth / 2;
        int end = centerX + textWidth / 2;
        if (start < x || end > x + width) {
            Objects.requireNonNull(textRenderer);
            AbstractWidget.renderScrollingString((GuiGraphics)context, (Font)textRenderer, (Component)text, (int)x, (int)y, (int)(x + width), (int)(y + 9), (int)-1);
        } else {
            context.drawString(textRenderer, text, start, y, -1, true);
        }
    }

    public static void drawText(GuiGraphics context, int x, int y, int width, Component text) {
        Font textRenderer = Minecraft.getInstance().font;
        int textWidth = textRenderer.width((FormattedText)text);
        if (x + textWidth > x + width) {
            Objects.requireNonNull(textRenderer);
            AbstractWidget.renderScrollingString((GuiGraphics)context, (Font)textRenderer, (Component)text, (int)x, (int)y, (int)(x + width), (int)(y + 9), (int)-1);
        } else {
            context.drawString(textRenderer, text, x, y, -1, true);
        }
    }
}

