/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.client.command;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import net.lopymine.mossylib.MossyLib;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class CommandTextBuilder {
    private final String key;
    private final MutableComponent text;

    private CommandTextBuilder(String key, Object ... args) {
        this.key = key;
        this.text = CommandTextBuilder.translatable(key, args);
    }

    private static MutableComponent translatable(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (CommandTextBuilder.isPrimitive(object) || object instanceof Component) continue;
            args[i] = String.valueOf(object);
        }
        return Component.literal((String)MossyLib.text(key, args).getString().replace("&", "\u00a7"));
    }

    private static boolean isPrimitive(Object object) {
        return object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    public static CommandTextBuilder startBuilder(String key, Object ... args) {
        return new CommandTextBuilder("command." + key, args);
    }

    public CommandTextBuilder withShowEntity(EntityType<?> type, UUID uuid, String name) {
        return this.withShowEntity(type, uuid, (Component)Component.literal((String)name));
    }

    public CommandTextBuilder withShowEntity(EntityType<?> type, UUID uuid, Component name) {
        HoverEvent hoverEvent = CommandTextBuilder.getHoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(type, uuid, name));
        return this.withHoverEvent(hoverEvent);
    }

    public CommandTextBuilder withHoverText(Object ... args) {
        MutableComponent hoverText = CommandTextBuilder.translatable(this.key + ".hover_text", args);
        HoverEvent hoverEvent = CommandTextBuilder.getHoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText);
        return this.withHoverEvent(hoverEvent);
    }

    public CommandTextBuilder withHoverEvent(HoverEvent hoverEvent) {
        Style style = this.text.getStyle().withHoverEvent(hoverEvent);
        this.text.setStyle(style);
        return this;
    }

    public CommandTextBuilder withCopyToClipboard(Object value) {
        ClickEvent clickEvent = CommandTextBuilder.getClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value);
        return this.withClickEvent(clickEvent);
    }

    public CommandTextBuilder withClickEvent(ClickEvent clickEvent) {
        Style style = this.text.getStyle().withClickEvent(clickEvent);
        this.text.setStyle(style);
        return this;
    }

    public static <T> HoverEvent getHoverEvent(HoverEvent.Action action, T value) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case HoverEvent.Action.SHOW_TEXT -> new HoverEvent.ShowText((Component)value);
            case HoverEvent.Action.SHOW_ITEM -> new HoverEvent.ShowItem((ItemStack)value);
            case HoverEvent.Action.SHOW_ENTITY -> new HoverEvent.ShowEntity((HoverEvent.EntityTooltipInfo)value);
        };
    }

    public static ClickEvent getClickEvent(ClickEvent.Action action, Object value) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case ClickEvent.Action.OPEN_URL -> new ClickEvent.OpenUrl((URI)value);
            case ClickEvent.Action.RUN_COMMAND -> new ClickEvent.RunCommand((String)value);
            case ClickEvent.Action.SUGGEST_COMMAND -> new ClickEvent.SuggestCommand((String)value);
            case ClickEvent.Action.CHANGE_PAGE -> new ClickEvent.ChangePage(((Integer)value).intValue());
            case ClickEvent.Action.COPY_TO_CLIPBOARD -> new ClickEvent.CopyToClipboard((String)value);
            case ClickEvent.Action.OPEN_FILE -> {
                if (value instanceof File) {
                    File file = (File)value;
                    yield new ClickEvent.OpenFile(file);
                }
                if (value instanceof Path) {
                    Path path = (Path)value;
                    yield new ClickEvent.OpenFile(path);
                }
                yield new ClickEvent.OpenFile((String)value);
            }
            case ClickEvent.Action.CUSTOM -> new ClickEvent.Custom((ResourceLocation)value, Optional.empty());
            case ClickEvent.Action.SHOW_DIALOG -> new ClickEvent.ShowDialog((Holder)value);
        };
    }

    public Component build() {
        return this.text;
    }
}

