/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mossylib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lopymine.mossylib.client.MossyLibClient;

public final class CodecUtils {
    public static <A> Codec<A> recursive(String name, Function<Codec<A>, Codec<A>> wrapped) {
        return Codec.recursive((String)name, wrapped);
    }

    public static <A> A parseNewInstanceHacky(Codec<A> codec) {
        try {
            return (A)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)"{}")).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create new instance of config in the %s mod".formatted("MossyLib"), e);
        }
    }

    public static <A, B> RecordCodecBuilder<A, B> option(String optionId, B defValue, Codec<B> codec, Function<A, B> getter) {
        return codec.optionalFieldOf(optionId).xmap(o -> o.orElse(defValue), Optional::ofNullable).forGetter(getter);
    }

    public static <A, B> RecordCodecBuilder<A, HashSet<B>> option(String optionId, HashSet<B> defValue, Codec<B> codec, Function<A, HashSet<B>> getter) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf(optionId).xmap(o -> o.orElse(defValue), Optional::ofNullable).forGetter(getter);
    }

    public static <T, A, B> RecordCodecBuilder<T, HashMap<A, B>> option(String optionId, HashMap<A, B> defValue, Codec<A> codecA, Codec<B> codecB, Function<T, HashMap<A, B>> getter) {
        return Codec.unboundedMap(codecA, codecB).xmap(HashMap::new, HashMap::new).optionalFieldOf(optionId).xmap(o -> o.orElse(defValue), Optional::ofNullable).forGetter(getter);
    }

    public static <A, B> RecordCodecBuilder<A, B> option(String optionId, Supplier<B> defValue, Codec<B> codec, Function<A, B> getter) {
        return codec.optionalFieldOf(optionId).xmap(o -> o.orElse(defValue.get()), Optional::ofNullable).forGetter(getter);
    }

    public static <A, B> RecordCodecBuilder<A, B> option(String optionId, Codec<B> codec, Function<A, B> getter, Object ... ignored) {
        return codec.fieldOf(optionId).forGetter(getter);
    }

    public static <A, B> RecordCodecBuilder<A, Optional<B>> option(String optionId, Codec<B> codec, Function<A, Optional<B>> getter) {
        return codec.optionalFieldOf(optionId).forGetter(getter);
    }

    public static <A, B> RecordCodecBuilder<A, ArrayList<B>> option(String optionId, ArrayList<B> defValue, Codec<B> codec, Function<A, ArrayList<B>> getter) {
        return codec.listOf().xmap(ArrayList::new, ArrayList::new).optionalFieldOf(optionId).xmap(o -> o.orElse(defValue), Optional::ofNullable).forGetter(getter);
    }

    public static <T> void decode(Codec<T> codec, JsonElement o, Consumer<T> consumer) {
        try {
            Object value = ((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)o).getOrThrow()).getFirst();
            consumer.accept(value);
        }
        catch (Exception e) {
            MossyLibClient.LOGGER.warn("Failed to decode JsonElement:", e);
        }
    }

    public static <T> T decode(String id, Codec<T> codec, JsonObject o) {
        if (o.has(id)) {
            try {
                return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)o.get(id)).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                MossyLibClient.LOGGER.warn("Failed to decode \"%s\" from JsonObject:".formatted(id), e);
            }
        }
        return null;
    }

    public static <T> T decode(String id, T fallback, Codec<T> codec, JsonObject o) {
        if (o.has(id)) {
            try {
                return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)o.get(id)).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                MossyLibClient.LOGGER.warn("Failed to decode \"%s\" from JsonObject:".formatted(id), e);
            }
        }
        return fallback;
    }
}

