/*
 * Decompiled with CFR 0.152.
 */
package sguest.jeimultiblocks.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import sguest.jeimultiblocks.ContentHelper;
import sguest.jeimultiblocks.JeiMultiblocksEventHandler;
import sguest.jeimultiblocks.MultiblockUtils;
import sguest.jeimultiblocks.jei.MultiblockRecipeCategory;

@JeiPlugin
public class JeiModPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeimultiblocks", "plugin");
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ContentHelper.getHammer(), new RecipeType[]{MultiblockRecipeCategory.recipeType});
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockRecipeCategory(guiHelper)});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        JeiMultiblocksEventHandler.registerCallback(() -> {
            jeiRuntime.getRecipeManager().addRecipes(MultiblockRecipeCategory.recipeType, MultiblockUtils.getMultiblockRecipes());
            return true;
        });
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, MultiblockUtils.getMultiblockItems());
    }
}

