/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockSeatEntity
extends Entity {
    private BlockPos attachedBlock;

    public BlockSeatEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setInvisible(true);
        this.noCulling = true;
    }

    public void setAttachedBlock(BlockPos pos) {
        this.attachedBlock = pos;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        if (tag.contains("AttachedBlockX")) {
            int x = tag.getInt("AttachedBlockX");
            int y = tag.getInt("AttachedBlockY");
            int z = tag.getInt("AttachedBlockZ");
            this.attachedBlock = new BlockPos(x, y, z);
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        if (this.attachedBlock != null) {
            tag.putInt("AttachedBlockX", this.attachedBlock.getX());
            tag.putInt("AttachedBlockY", this.attachedBlock.getY());
            tag.putInt("AttachedBlockZ", this.attachedBlock.getZ());
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.attachedBlock != null && !this.isBlockValid()) {
            this.ejectPassengers();
            this.discard();
        }
        if (!this.isVehicle() && this.tickCount > 100) {
            this.discard();
        }
    }

    private boolean isBlockValid() {
        if (this.attachedBlock == null) {
            return false;
        }
        BlockState state = this.level().getBlockState(this.attachedBlock);
        return !state.isAir();
    }

    public void move(@NotNull MoverType type, @NotNull Vec3 pos) {
    }

    public boolean isPickable() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity entity, @NotNull EntityDimensions dimensions, float partialTick) {
        if (this.attachedBlock != null) {
            BlockState state = this.level().getBlockState(this.attachedBlock);
            double yOffset = 0.8;
            if (state.getBlock() instanceof StairBlock) {
                double d = yOffset = state.getValue((Property)StairBlock.HALF) == Half.TOP ? 0.8 : 0.3;
            }
            if (state.getBlock() instanceof SlabBlock) {
                SlabType slabType = (SlabType)state.getValue((Property)SlabBlock.TYPE);
                yOffset = switch (slabType) {
                    default -> throw new MatchException(null, null);
                    case SlabType.TOP -> 0.8;
                    case SlabType.BOTTOM -> 0.3;
                    case SlabType.DOUBLE -> 0.8;
                };
            }
            return new Vec3(0.0, yOffset, 0.0);
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick);
    }

    protected void addPassenger(@NotNull Entity passenger) {
        super.addPassenger(passenger);
        if (this.attachedBlock != null) {
            BlockState state = this.level().getBlockState(this.attachedBlock);
            double yOffset = (double)this.attachedBlock.getY() + 1.8;
            if (state.getBlock() instanceof StairBlock) {
                yOffset = state.getValue((Property)StairBlock.HALF) == Half.TOP ? (double)this.attachedBlock.getY() + 1.8 : (double)this.attachedBlock.getY() + 0.8;
                double horizontalOffset = 0.25;
                switch ((Direction)state.getValue((Property)StairBlock.FACING)) {
                    case NORTH: {
                        passenger.setPos((double)this.attachedBlock.getX() + 0.5, yOffset, (double)this.attachedBlock.getZ() + 0.5 + horizontalOffset);
                        break;
                    }
                    case SOUTH: {
                        passenger.setPos((double)this.attachedBlock.getX() + 0.5, yOffset, (double)this.attachedBlock.getZ() + 0.5 - horizontalOffset);
                        break;
                    }
                    case EAST: {
                        passenger.setPos((double)this.attachedBlock.getX() + 0.5 - horizontalOffset, yOffset, (double)this.attachedBlock.getZ() + 0.5);
                        break;
                    }
                    case WEST: {
                        passenger.setPos((double)this.attachedBlock.getX() + 0.5 + horizontalOffset, yOffset, (double)this.attachedBlock.getZ() + 0.5);
                    }
                }
                return;
            }
            if (state.getBlock() instanceof SlabBlock) {
                SlabType slabType = (SlabType)state.getValue((Property)SlabBlock.TYPE);
                yOffset = switch (slabType) {
                    default -> throw new MatchException(null, null);
                    case SlabType.TOP -> (double)this.attachedBlock.getY() + 1.8;
                    case SlabType.BOTTOM -> (double)this.attachedBlock.getY() + 0.8;
                    case SlabType.DOUBLE -> (double)this.attachedBlock.getY() + 1.8;
                };
            }
            passenger.setPos((double)this.attachedBlock.getX() + 0.5, yOffset, (double)this.attachedBlock.getZ() + 0.5);
        }
    }

    protected void removePassenger(@NotNull Entity passenger) {
        if (this.attachedBlock != null) {
            Vec3 safePos = this.findSafeDismountPosition(passenger);
            passenger.setPos(safePos.x, safePos.y, safePos.z);
        }
        super.removePassenger(passenger);
    }

    public void ejectPassengers() {
        for (Entity passenger : this.getPassengers()) {
            if (this.attachedBlock == null) continue;
            Vec3 safePos = this.findSafeDismountPosition(passenger);
            passenger.setPos(safePos.x, safePos.y, safePos.z);
        }
        super.ejectPassengers();
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        if (this.attachedBlock != null) {
            return this.findSafeDismountPosition((Entity)passenger);
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    private Vec3 findSafeDismountPosition(Entity passenger) {
        BlockState state = this.level().getBlockState(this.attachedBlock);
        double baseY = (double)this.attachedBlock.getY() + 1.0;
        if (state.getBlock() instanceof StairBlock) {
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            baseY = half == Half.TOP ? (double)this.attachedBlock.getY() + 1.0 : (double)this.attachedBlock.getY() + 0.5;
        } else if (state.getBlock() instanceof SlabBlock) {
            SlabType slabType = (SlabType)state.getValue((Property)SlabBlock.TYPE);
            baseY = switch (slabType) {
                default -> throw new MatchException(null, null);
                case SlabType.TOP -> (double)this.attachedBlock.getY() + 1.0;
                case SlabType.BOTTOM -> (double)this.attachedBlock.getY() + 0.5;
                case SlabType.DOUBLE -> (double)this.attachedBlock.getY() + 1.0;
            };
        }
        float yRot = passenger.getYRot();
        double radians = Math.toRadians(yRot);
        double frontX = -Math.sin(radians) * 2.0;
        double frontZ = Math.cos(radians) * 2.0;
        Vec3 frontPos = new Vec3((double)this.attachedBlock.getX() + 0.5 + frontX, baseY, (double)this.attachedBlock.getZ() + 0.5 + frontZ);
        if (this.isSafePosition(frontPos, passenger)) {
            return frontPos;
        }
        double[] distances = new double[]{2.0, 2.5, 3.0};
        double[] angles = new double[]{0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};
        for (double distance : distances) {
            for (double angle : angles) {
                double angleRad = Math.toRadians(angle);
                double xOffset = Math.sin(angleRad) * distance;
                double zOffset = Math.cos(angleRad) * distance;
                Vec3 testPos = new Vec3((double)this.attachedBlock.getX() + 0.5 + xOffset, baseY, (double)this.attachedBlock.getZ() + 0.5 + zOffset);
                if (!this.isSafePosition(testPos, passenger)) continue;
                return testPos;
            }
        }
        for (int i = 1; i <= 5; ++i) {
            Vec3 highPos = new Vec3((double)this.attachedBlock.getX() + 0.5, baseY + (double)i, (double)this.attachedBlock.getZ() + 0.5);
            if (!this.isSafePosition(highPos, passenger)) continue;
            return highPos;
        }
        return new Vec3((double)this.attachedBlock.getX() + 0.5, baseY, (double)this.attachedBlock.getZ() + 0.5);
    }

    private boolean isSafePosition(Vec3 pos, Entity passenger) {
        BlockPos feetPos = new BlockPos((int)Math.floor(pos.x), (int)Math.floor(pos.y), (int)Math.floor(pos.z));
        BlockPos headPos = feetPos.above();
        BlockPos belowPos = feetPos.below();
        BlockState belowState = this.level().getBlockState(belowPos);
        if (belowState.isAir()) {
            return false;
        }
        BlockState feetState = this.level().getBlockState(feetPos);
        if (!feetState.isAir() && feetState.canOcclude()) {
            return false;
        }
        BlockState headState = this.level().getBlockState(headPos);
        if (!headState.isAir() && headState.canOcclude()) {
            return false;
        }
        double minX = feetPos.getX();
        double maxX = (double)feetPos.getX() + 1.0;
        double minZ = feetPos.getZ();
        double maxZ = (double)feetPos.getZ() + 1.0;
        if (pos.x <= minX + 0.3 || pos.x >= maxX - 0.3 || pos.z <= minZ + 0.3 || pos.z >= maxZ - 0.3) {
            return !feetState.canOcclude();
        }
        return true;
    }
}

