/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.events;

import com.prizowo.rideeverything.client.KeyBindings;
import com.prizowo.rideeverything.network.MountControlPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="rideeverything", value={Dist.CLIENT})
public class ClientMountControlEvents {
    private static boolean wasJumping = false;
    private static boolean wasDescending = false;
    private static float lastForward = 0.0f;
    private static float lastStrafe = 0.0f;
    private static boolean wasSprinting = false;
    private static long lastWPressTime = 0L;
    private static final long DOUBLE_PRESS_TIME = 300L;
    private static boolean isSprinting = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && player.isPassenger() && player.getVehicle() instanceof Mob && !(player.getVehicle() instanceof AbstractHorse)) {
            boolean jumping = minecraft.options.keyJump.isDown();
            boolean descending = KeyBindings.KEY_DESCEND.isDown();
            float forward = player.zza;
            float strafe = player.xxa;
            if (forward > 0.0f) {
                long currentTime = System.currentTimeMillis();
                if (lastForward <= 0.0f) {
                    if (currentTime - lastWPressTime < 300L) {
                        isSprinting = true;
                    }
                    lastWPressTime = currentTime;
                }
            } else {
                isSprinting = false;
            }
            if (jumping != wasJumping || descending != wasDescending || forward != lastForward || strafe != lastStrafe || isSprinting != wasSprinting) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MountControlPacket(jumping, descending, forward, strafe, isSprinting), (CustomPacketPayload[])new CustomPacketPayload[0]);
                wasJumping = jumping;
                wasDescending = descending;
                lastForward = forward;
                lastStrafe = strafe;
                wasSprinting = isSprinting;
            }
        } else {
            wasJumping = false;
            wasDescending = false;
            lastForward = 0.0f;
            lastStrafe = 0.0f;
            wasSprinting = false;
            isSprinting = false;
        }
    }
}

