/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.events;

import com.prizowo.rideeverything.util.FlyingEntityConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="rideeverything")
public class MountControlEvents {
    private static final Map<Class<?>, Boolean> flyingEntityCache = new HashMap();
    private static final double SPRINT_SPEED_MULTIPLIER = 1.3;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Mob mt;
        Entity et;
        Player player = event.getEntity();
        if (player.isPassenger() && (et = player.getVehicle()) instanceof Mob && !((mt = (Mob)et) instanceof AbstractHorse)) {
            boolean jumping = player.getPersistentData().getBoolean("mounting_jumping");
            boolean descending = player.getPersistentData().getBoolean("mounting_descending");
            float forward = player.getPersistentData().getFloat("mounting_forward");
            float strafe = player.getPersistentData().getFloat("mounting_strafe");
            boolean sprinting = player.getPersistentData().getBoolean("mounting_sprinting");
            boolean isFlying = MountControlEvents.isFlying(mt);
            if (isFlying) {
                MountControlEvents.handleFlyingMobControl(mt, player, jumping, descending, forward, strafe, sprinting);
            } else {
                MountControlEvents.handleGroundMobControl(mt, player, jumping, forward, strafe, sprinting);
            }
        }
    }

    private static void handleFlyingMobControl(Mob mob, Player player, boolean jumping, boolean descending, float forward, float strafe, boolean isSprinting) {
        mob.setYRot(player.getYRot());
        mob.yRotO = mob.getYRot();
        mob.setYBodyRot(mob.getYRot());
        mob.setYHeadRot(mob.getYRot());
        Vec3 currentVelocity = mob.getDeltaMovement();
        double verticalMotion = jumping ? 0.4 : (descending ? -0.4 : Math.max(-0.1, currentVelocity.y * 0.8));
        double horizontalSpeed = 0.35;
        if (isSprinting && forward > 0.0f) {
            horizontalSpeed *= 1.3;
        }
        float yaw = player.getYRot();
        double rad = Math.toRadians(yaw);
        double motionX = 0.0;
        double motionZ = 0.0;
        if (forward != 0.0f || strafe != 0.0f) {
            motionX = -Math.sin(rad) * (double)forward * horizontalSpeed;
            motionZ = Math.cos(rad) * (double)forward * horizontalSpeed;
            motionX += Math.cos(rad) * (double)strafe * horizontalSpeed;
            motionZ += Math.sin(rad) * (double)strafe * horizontalSpeed;
        } else {
            motionX = currentVelocity.x * 0.8;
            motionZ = currentVelocity.z * 0.8;
        }
        Vec3 newVelocity = new Vec3(motionX, verticalMotion, motionZ);
        mob.setDeltaMovement(newVelocity);
        mob.hasImpulse = true;
        mob.setNoGravity(true);
    }

    private static void handleGroundMobControl(Mob mob, Player player, boolean jumping, float forward, float strafe, boolean isSprinting) {
        if (jumping && mob.onGround()) {
            double jumpPower = 0.5;
            if (forward != 0.0f || strafe != 0.0f) {
                jumpPower *= 1.2;
            }
            Vec3 currentVelocity = mob.getDeltaMovement();
            mob.setDeltaMovement(currentVelocity.x, jumpPower, currentVelocity.z);
            mob.hasImpulse = true;
        }
        mob.setNoGravity(false);
        if (forward != 0.0f || strafe != 0.0f) {
            mob.setYRot(player.getYRot());
            mob.yRotO = mob.getYRot();
            mob.setYBodyRot(mob.getYRot());
            mob.setYHeadRot(mob.getYRot());
            Vec3 currentVelocity = mob.getDeltaMovement();
            float yaw = player.getYRot();
            double rad = Math.toRadians(yaw);
            double speed = mob.getSpeed();
            if (isSprinting && forward > 0.0f) {
                speed *= 1.3;
            }
            double motionX = -Math.sin(rad) * (double)forward * speed;
            double motionZ = Math.cos(rad) * (double)forward * speed;
            Vec3 newVelocity = new Vec3(motionX += Math.cos(rad) * (double)strafe * speed, currentVelocity.y, motionZ += Math.sin(rad) * (double)strafe * speed);
            mob.setDeltaMovement(newVelocity);
            mob.hasImpulse = true;
        }
    }

    private static boolean isFlying(Mob mob) {
        Class<?> mobClass = mob.getClass();
        if (flyingEntityCache.containsKey(mobClass)) {
            return flyingEntityCache.get(mobClass);
        }
        boolean result = false;
        EntityType type = mob.getType();
        if (FlyingEntityConfig.isExcludedFromFlying(type)) {
            flyingEntityCache.put(mobClass, false);
            return false;
        }
        if (FlyingEntityConfig.isConfiguredAsFlying(type)) {
            flyingEntityCache.put(mobClass, true);
            return true;
        }
        if (mob instanceof FlyingAnimal) {
            result = true;
        } else if (type == EntityType.BAT || type == EntityType.BEE || type == EntityType.BLAZE || type == EntityType.PHANTOM || type == EntityType.GHAST || type == EntityType.ALLAY || type == EntityType.VEX || type == EntityType.WITHER) {
            result = true;
        }
        flyingEntityCache.put(mobClass, result);
        return result;
    }
}

