/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.network;

import com.prizowo.rideeverything.entity.BlockSeatEntity;
import com.prizowo.rideeverything.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record CreateBlockSeatPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rideeverything", (String)"create_block_seat");
    public static final CustomPacketPayload.Type<CreateBlockSeatPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, CreateBlockSeatPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> buf.writeBlockPos(packet.pos()), buf -> new CreateBlockSeatPacket(buf.readBlockPos()));

    public static void handle(CreateBlockSeatPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player;
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer && (player = (ServerPlayer)patt0$temp).level() != null) {
                if (player.level().getBlockState(packet.pos()).isAir()) {
                    return;
                }
                BlockSeatEntity seat = new BlockSeatEntity(ModEntities.BLOCK_SEAT.get(), player.level());
                BlockState state = player.level().getBlockState(packet.pos());
                double entityY = (double)packet.pos().getY() + 1.0;
                if (state.getBlock() instanceof StairBlock) {
                    entityY = state.getValue((Property)StairBlock.HALF) == Half.TOP ? (double)packet.pos().getY() + 1.0 : (double)packet.pos().getY() + 0.5;
                } else if (state.getBlock() instanceof SlabBlock) {
                    SlabType slabType = (SlabType)state.getValue((Property)SlabBlock.TYPE);
                    entityY = switch (slabType) {
                        default -> throw new MatchException(null, null);
                        case SlabType.TOP -> (double)packet.pos().getY() + 1.0;
                        case SlabType.BOTTOM -> (double)packet.pos().getY() + 0.5;
                        case SlabType.DOUBLE -> (double)packet.pos().getY() + 1.0;
                    };
                }
                seat.setPos((double)packet.pos().getX() + 0.5, entityY, (double)packet.pos().getZ() + 0.5);
                seat.setAttachedBlock(packet.pos());
                if (player.level().addFreshEntity((Entity)seat)) {
                    player.startRiding((Entity)seat, true);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

