/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RideConfirmPacket(boolean isBlockSeat, int riderId, int targetId, boolean mounting, BlockPos blockPos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rideeverything", (String)"ride_confirm");
    public static final CustomPacketPayload.Type<RideConfirmPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RideConfirmPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBoolean(packet.isBlockSeat());
        if (packet.isBlockSeat()) {
            buf.writeBlockPos(packet.blockPos());
        } else {
            buf.writeInt(packet.riderId());
            buf.writeInt(packet.targetId());
            buf.writeBoolean(packet.mounting());
        }
    }, buf -> {
        boolean isBlockSeat = buf.readBoolean();
        if (isBlockSeat) {
            BlockPos pos = buf.readBlockPos();
            return new RideConfirmPacket(true, -1, -1, true, pos);
        }
        int riderId = buf.readInt();
        int targetId = buf.readInt();
        boolean mounting = buf.readBoolean();
        return new RideConfirmPacket(false, riderId, targetId, mounting, null);
    });

    public RideConfirmPacket(int riderId, int targetId, boolean mounting) {
        this(false, riderId, targetId, mounting, null);
    }

    public RideConfirmPacket(BlockPos blockPos) {
        this(true, -1, -1, true, blockPos);
    }

    public static void handle(RideConfirmPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (Minecraft.getInstance().level != null && !packet.isBlockSeat()) {
                int riderId = packet.riderId();
                int targetId = packet.targetId();
                boolean mounting = packet.mounting();
                Entity rider = Minecraft.getInstance().level.getEntity(riderId);
                Entity target = Minecraft.getInstance().level.getEntity(targetId);
                if (rider != null && target != null) {
                    if (mounting) {
                        if (!rider.isPassenger() || rider.getVehicle() != target) {
                            rider.startRiding(target, true);
                        }
                    } else if (rider.isPassenger() && rider.getVehicle() == target) {
                        rider.stopRiding();
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

