/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.network;

import com.prizowo.rideeverything.entity.BlockSeatEntity;
import com.prizowo.rideeverything.network.RideConfirmPacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RidePacket(boolean isEntityInteraction, int entityId, boolean isMount, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.parse((String)"rideeverything:ride_packet");
    public static final CustomPacketPayload.Type<RidePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RidePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBoolean(packet.isEntityInteraction());
        if (packet.isEntityInteraction()) {
            buf.writeInt(packet.entityId());
            buf.writeBoolean(packet.isMount());
        } else {
            buf.writeBlockPos(packet.pos());
        }
    }, buf -> {
        boolean isEntityInteraction = buf.readBoolean();
        if (isEntityInteraction) {
            int entityId = buf.readInt();
            boolean isMount = buf.readBoolean();
            return new RidePacket(true, entityId, isMount, null);
        }
        BlockPos pos = buf.readBlockPos();
        return new RidePacket(false, -1, false, pos);
    });

    public RidePacket(int entityId, boolean isMount) {
        this(true, entityId, isMount, null);
    }

    public RidePacket(BlockPos pos) {
        this(false, -1, false, pos);
    }

    public static void handle(RidePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerLevel level = player.serverLevel();
                if (packet.isEntityInteraction()) {
                    Entity target = level.getEntity(packet.entityId());
                    if (target != null) {
                        if (packet.isMount()) {
                            boolean success = player.startRiding(target, true);
                            if (success) {
                                RideConfirmPacket confirmPacket = new RideConfirmPacket(player.getId(), packet.entityId(), true);
                                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)confirmPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                                if (target instanceof ServerPlayer) {
                                    ServerPlayer targetPlayer = (ServerPlayer)target;
                                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)targetPlayer, (CustomPacketPayload)confirmPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                                }
                            }
                        } else if (player.isPassenger()) {
                            Entity vehicle = player.getVehicle();
                            player.stopRiding();
                            if (vehicle != null) {
                                RideConfirmPacket confirmPacket = new RideConfirmPacket(player.getId(), vehicle.getId(), false);
                                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)confirmPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                                if (vehicle instanceof ServerPlayer) {
                                    ServerPlayer vehiclePlayer = (ServerPlayer)vehicle;
                                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)vehiclePlayer, (CustomPacketPayload)confirmPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                                }
                            }
                        }
                    }
                } else {
                    if (RidePacket.hasSeatEntityAt(level, packet.pos())) {
                        return;
                    }
                    if (!RidePacket.isEnoughSpaceAbove(level, packet.pos())) {
                        return;
                    }
                    BlockState state = level.getBlockState(packet.pos());
                    if (state.isAir()) {
                        return;
                    }
                }
            }
        });
    }

    private static boolean hasSeatEntityAt(ServerLevel level, BlockPos pos) {
        List entities = level.getEntities(null, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)));
        for (Entity entity : entities) {
            if (!(entity instanceof BlockSeatEntity)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnoughSpaceAbove(ServerLevel level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        List entities = level.getEntities(null, new AABB((double)abovePos.getX(), (double)abovePos.getY(), (double)abovePos.getZ(), (double)(abovePos.getX() + 1), (double)(abovePos.getY() + 1), (double)(abovePos.getZ() + 1)));
        if (!entities.isEmpty()) {
            return false;
        }
        BlockState aboveState = level.getBlockState(abovePos);
        return aboveState.isAir() || !aboveState.canOcclude();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

