/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="rideeverything", bus=EventBusSubscriber.Bus.MOD)
public class FlyingEntityConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ADDITIONAL_FLYING_ENTITIES;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> EXCLUDED_FLYING_ENTITIES;
    private static final Set<EntityType<?>> additionalFlyingEntities;
    private static final Set<EntityType<?>> excludedFlyingEntities;

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC);
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        FlyingEntityConfig.parseConfig();
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        FlyingEntityConfig.parseConfig();
    }

    private static void parseConfig() {
        EntityType entityType;
        ResourceLocation entityId2;
        additionalFlyingEntities.clear();
        excludedFlyingEntities.clear();
        for (String entityStr : (List)ADDITIONAL_FLYING_ENTITIES.get()) {
            try {
                entityId2 = ResourceLocation.parse((String)entityStr);
                entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId2);
                additionalFlyingEntities.add(entityType);
            }
            catch (Exception entityId2) {}
        }
        for (String entityStr : (List)EXCLUDED_FLYING_ENTITIES.get()) {
            try {
                entityId2 = ResourceLocation.parse((String)entityStr);
                entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId2);
                excludedFlyingEntities.add(entityType);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isConfiguredAsFlying(EntityType<?> entityType) {
        return additionalFlyingEntities.contains(entityType);
    }

    public static boolean isExcludedFromFlying(EntityType<?> entityType) {
        return excludedFlyingEntities.contains(entityType);
    }

    static {
        additionalFlyingEntities = new HashSet();
        excludedFlyingEntities = new HashSet();
        BUILDER.comment("RideEverything Flying Entity Configuration").push("flying_entities");
        ADDITIONAL_FLYING_ENTITIES = BUILDER.comment("Additional flying entity types, format: 'modid:entity_name'").worldRestart().defineList("additional_flying_entities", new ArrayList(), obj -> obj instanceof String);
        EXCLUDED_FLYING_ENTITIES = BUILDER.comment("Excluded entity types, format: 'modid:entity_name' (can override default behavior)").worldRestart().defineList("excluded_flying_entities", new ArrayList(), obj -> obj instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

