/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.util;

import com.prizowo.rideeverything.network.CreateBlockSeatPacket;
import com.prizowo.rideeverything.network.RidePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class RideHandler {
    public static void handleRideKey() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Entity target = mc.crosshairPickEntity;
        if (target != null && !player.isPassenger()) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target) == player) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new RidePacket(target.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            HitResult hit = mc.hitResult;
            if (hit != null && hit.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos pos = blockHit.getBlockPos();
                PacketDistributor.sendToServer((CustomPacketPayload)new CreateBlockSeatPacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void handleDismountKey() {
        Entity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isPassenger() && (vehicle = player.getVehicle()) != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RidePacket(vehicle.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

