/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockSeatEntity
extends Entity {
    private BlockPos attachedBlock;

    public BlockSeatEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_6842_(true);
    }

    public void setAttachedBlock(BlockPos pos) {
        this.attachedBlock = pos;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        if (tag.m_128441_("AttachedBlockX")) {
            int x = tag.m_128451_("AttachedBlockX");
            int y = tag.m_128451_("AttachedBlockY");
            int z = tag.m_128451_("AttachedBlockZ");
            this.attachedBlock = new BlockPos(x, y, z);
        }
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        if (this.attachedBlock != null) {
            tag.m_128405_("AttachedBlockX", this.attachedBlock.m_123341_());
            tag.m_128405_("AttachedBlockY", this.attachedBlock.m_123342_());
            tag.m_128405_("AttachedBlockZ", this.attachedBlock.m_123343_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20160_() || this.attachedBlock != null && !this.isBlockValid()) {
            this.m_20153_();
            this.m_146870_();
        }
    }

    private boolean isBlockValid() {
        if (this.attachedBlock == null) {
            return false;
        }
        BlockState state = this.m_9236_().m_8055_(this.attachedBlock);
        return !state.m_60795_();
    }

    public void m_6478_(@NotNull MoverType type, @NotNull Vec3 pos) {
    }

    public boolean m_6087_() {
        return super.m_6087_();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public double m_6048_() {
        if (this.attachedBlock != null) {
            BlockState state = this.m_9236_().m_8055_(this.attachedBlock);
            if (state.m_60734_() instanceof StairBlock) {
                return state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP ? 1.2 : 0.5;
            }
            if (state.m_60734_() instanceof SlabBlock) {
                SlabType slabType = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
                return switch (slabType) {
                    default -> throw new IncompatibleClassChangeError();
                    case SlabType.TOP, SlabType.DOUBLE -> 1.2;
                    case SlabType.BOTTOM -> 0.5;
                };
            }
        }
        return 0.4;
    }

    protected void m_20348_(@NotNull Entity passenger) {
        super.m_20348_(passenger);
        if (this.attachedBlock != null) {
            BlockState state = this.m_9236_().m_8055_(this.attachedBlock);
            double yOffset = (double)this.attachedBlock.m_123342_() + 0.4;
            if (state.m_60734_() instanceof StairBlock) {
                yOffset = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP ? (double)this.attachedBlock.m_123342_() + 1.1 : (double)this.attachedBlock.m_123342_() + 0.5;
                double horizontalOffset = 0.25;
                switch ((Direction)state.m_61143_((Property)StairBlock.f_56841_)) {
                    case NORTH: {
                        passenger.m_6034_((double)this.attachedBlock.m_123341_() + 0.5, yOffset, (double)this.attachedBlock.m_123343_() + 0.5 + horizontalOffset);
                        break;
                    }
                    case SOUTH: {
                        passenger.m_6034_((double)this.attachedBlock.m_123341_() + 0.5, yOffset, (double)this.attachedBlock.m_123343_() + 0.5 - horizontalOffset);
                        break;
                    }
                    case EAST: {
                        passenger.m_6034_((double)this.attachedBlock.m_123341_() + 0.5 - horizontalOffset, yOffset, (double)this.attachedBlock.m_123343_() + 0.5);
                        break;
                    }
                    case WEST: {
                        passenger.m_6034_((double)this.attachedBlock.m_123341_() + 0.5 + horizontalOffset, yOffset, (double)this.attachedBlock.m_123343_() + 0.5);
                    }
                }
                return;
            }
            if (state.m_60734_() instanceof SlabBlock) {
                SlabType slabType = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
                yOffset = switch (slabType) {
                    default -> throw new IncompatibleClassChangeError();
                    case SlabType.TOP, SlabType.DOUBLE -> (double)this.attachedBlock.m_123342_() + 1.1;
                    case SlabType.BOTTOM -> (double)this.attachedBlock.m_123342_() + 0.5;
                };
            }
            passenger.m_6034_((double)this.attachedBlock.m_123341_() + 0.5, yOffset, (double)this.attachedBlock.m_123343_() + 0.5);
        }
    }

    protected void m_20351_(@NotNull Entity passenger) {
        if (this.attachedBlock != null) {
            Vec3 safePos = this.findSafeDismountPosition(passenger);
            passenger.m_6034_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
        }
        super.m_20351_(passenger);
    }

    public void m_20153_() {
        for (Entity passenger : this.m_20197_()) {
            if (this.attachedBlock == null) continue;
            Vec3 safePos = this.findSafeDismountPosition(passenger);
            passenger.m_6034_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
        }
        super.m_20153_();
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        if (this.attachedBlock != null) {
            return this.findSafeDismountPosition((Entity)passenger);
        }
        return super.m_7688_(passenger);
    }

    private Vec3 findSafeDismountPosition(Entity passenger) {
        BlockState state = this.m_9236_().m_8055_(this.attachedBlock);
        double baseY = (double)this.attachedBlock.m_123342_() + 1.0;
        if (state.m_60734_() instanceof StairBlock) {
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            baseY = half == Half.TOP ? (double)this.attachedBlock.m_123342_() + 2.0 : (double)this.attachedBlock.m_123342_() + 1.5;
        } else if (state.m_60734_() instanceof SlabBlock) {
            SlabType slabType = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            baseY = switch (slabType) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP, SlabType.DOUBLE -> (double)this.attachedBlock.m_123342_() + 2.0;
                case SlabType.BOTTOM -> (double)this.attachedBlock.m_123342_() + 1.5;
            };
        }
        float yRot = passenger.m_146908_();
        double radians = Math.toRadians(yRot);
        double frontX = -Math.sin(radians) * 1.8;
        double frontZ = Math.cos(radians) * 1.8;
        Vec3 frontPos = new Vec3((double)this.attachedBlock.m_123341_() + 0.5 + frontX, baseY, (double)this.attachedBlock.m_123343_() + 0.5 + frontZ);
        if (this.isSafePosition(frontPos, passenger)) {
            return frontPos;
        }
        double[] distances = new double[]{1.5, 2.0, 2.5};
        double[] angles = new double[]{0.0, 45.0, 90.0, 135.0, 180.0, 225.0, 270.0, 315.0};
        for (double distance : distances) {
            for (double angle : angles) {
                double angleRad = Math.toRadians(angle);
                double xOffset = Math.sin(angleRad) * distance;
                double zOffset = Math.cos(angleRad) * distance;
                Vec3 testPos = new Vec3((double)this.attachedBlock.m_123341_() + 0.5 + xOffset, baseY, (double)this.attachedBlock.m_123343_() + 0.5 + zOffset);
                if (!this.isSafePosition(testPos, passenger)) continue;
                return testPos;
            }
        }
        for (int i = 1; i <= 3; ++i) {
            Vec3 highPos = new Vec3((double)this.attachedBlock.m_123341_() + 0.5, baseY + (double)i, (double)this.attachedBlock.m_123343_() + 0.5);
            if (!this.isSafePosition(highPos, passenger)) continue;
            return highPos;
        }
        return new Vec3((double)this.attachedBlock.m_123341_() + 0.5, baseY, (double)this.attachedBlock.m_123343_() + 0.5);
    }

    private boolean isSafePosition(Vec3 pos, Entity passenger) {
        BlockPos feetPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_), (int)Math.floor(pos.f_82481_));
        BlockPos headPos = feetPos.m_7494_();
        BlockPos belowPos = feetPos.m_7495_();
        BlockState belowState = this.m_9236_().m_8055_(belowPos);
        if (belowState.m_60795_()) {
            return false;
        }
        BlockState feetState = this.m_9236_().m_8055_(feetPos);
        if (!feetState.m_60795_() && feetState.m_60815_()) {
            return false;
        }
        BlockState headState = this.m_9236_().m_8055_(headPos);
        if (!headState.m_60795_() && headState.m_60815_()) {
            return false;
        }
        double minX = feetPos.m_123341_();
        double maxX = (double)feetPos.m_123341_() + 1.0;
        double minZ = feetPos.m_123343_();
        double maxZ = (double)feetPos.m_123343_() + 1.0;
        if (pos.f_82479_ <= minX + 0.3 || pos.f_82479_ >= maxX - 0.3 || pos.f_82481_ <= minZ + 0.3 || pos.f_82481_ >= maxZ - 0.3) {
            return !feetState.m_60815_();
        }
        return true;
    }
}

