/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.events;

import com.prizowo.rideeverything.util.FlyingEntityConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rideeverything")
public class MountControlEvents {
    private static final Map<Class<?>, Boolean> flyingEntityCache = new HashMap();
    private static final double SPRINT_SPEED_MULTIPLIER = 1.3;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Mob mt;
        Entity et;
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player).m_20159_() && (et = player.m_20202_()) instanceof Mob && !((mt = (Mob)et) instanceof AbstractHorse)) {
            boolean jumping = player.getPersistentData().m_128471_("mounting_jumping");
            boolean descending = player.getPersistentData().m_128471_("mounting_descending");
            float forward = player.getPersistentData().m_128457_("mounting_forward");
            float strafe = player.getPersistentData().m_128457_("mounting_strafe");
            boolean sprinting = player.getPersistentData().m_128471_("mounting_sprinting");
            boolean isFlying = MountControlEvents.isFlying(mt);
            if (isFlying) {
                MountControlEvents.handleFlyingMobControl(mt, player, jumping, descending, forward, strafe, sprinting);
            } else {
                MountControlEvents.handleGroundMobControl(mt, player, jumping, forward, strafe, sprinting);
            }
        }
    }

    private static void handleFlyingMobControl(Mob mob, Player player, boolean jumping, boolean descending, float forward, float strafe, boolean isSprinting) {
        mob.m_146922_(player.m_146908_());
        mob.f_19859_ = mob.m_146908_();
        mob.m_5618_(mob.m_146908_());
        mob.m_5616_(mob.m_146908_());
        Vec3 currentVelocity = mob.m_20184_();
        double verticalMotion = jumping ? 0.4 : (descending ? -0.4 : Math.max(-0.1, currentVelocity.f_82480_ * 0.8));
        double horizontalSpeed = 0.35;
        if (isSprinting && forward > 0.0f) {
            horizontalSpeed *= 1.3;
        }
        float yaw = player.m_146908_();
        double rad = Math.toRadians(yaw);
        double motionX = 0.0;
        double motionZ = 0.0;
        if (forward != 0.0f || strafe != 0.0f) {
            motionX = -Math.sin(rad) * (double)forward * horizontalSpeed;
            motionZ = Math.cos(rad) * (double)forward * horizontalSpeed;
            motionX += Math.cos(rad) * (double)strafe * horizontalSpeed;
            motionZ += Math.sin(rad) * (double)strafe * horizontalSpeed;
        } else {
            motionX = currentVelocity.f_82479_ * 0.8;
            motionZ = currentVelocity.f_82481_ * 0.8;
        }
        Vec3 newVelocity = new Vec3(motionX, verticalMotion, motionZ);
        mob.m_20256_(newVelocity);
        mob.f_19812_ = true;
        mob.m_20242_(true);
    }

    private static void handleGroundMobControl(Mob mob, Player player, boolean jumping, float forward, float strafe, boolean isSprinting) {
        if (jumping && mob.m_20096_()) {
            double jumpPower = 0.5;
            if (forward != 0.0f || strafe != 0.0f) {
                jumpPower *= 1.2;
            }
            Vec3 currentVelocity = mob.m_20184_();
            mob.m_20334_(currentVelocity.f_82479_, jumpPower, currentVelocity.f_82481_);
            mob.f_19812_ = true;
        }
        mob.m_20242_(false);
        if (forward != 0.0f || strafe != 0.0f) {
            mob.m_146922_(player.m_146908_());
            mob.f_19859_ = mob.m_146908_();
            mob.m_5618_(mob.m_146908_());
            mob.m_5616_(mob.m_146908_());
            Vec3 currentVelocity = mob.m_20184_();
            float yaw = player.m_146908_();
            double rad = Math.toRadians(yaw);
            double speed = mob.m_6113_();
            if (isSprinting && forward > 0.0f) {
                speed *= 1.3;
            }
            double motionX = -Math.sin(rad) * (double)forward * speed;
            double motionZ = Math.cos(rad) * (double)forward * speed;
            Vec3 newVelocity = new Vec3(motionX += Math.cos(rad) * (double)strafe * speed, currentVelocity.f_82480_, motionZ += Math.sin(rad) * (double)strafe * speed);
            mob.m_20256_(newVelocity);
            mob.f_19812_ = true;
        }
    }

    private static boolean isFlying(Mob mob) {
        Class<?> mobClass = mob.getClass();
        if (flyingEntityCache.containsKey(mobClass)) {
            return flyingEntityCache.get(mobClass);
        }
        boolean result = false;
        EntityType type = mob.m_6095_();
        if (FlyingEntityConfig.isExcludedFromFlying(type)) {
            flyingEntityCache.put(mobClass, false);
            return false;
        }
        if (FlyingEntityConfig.isConfiguredAsFlying(type)) {
            flyingEntityCache.put(mobClass, true);
            return true;
        }
        if (mob instanceof FlyingAnimal) {
            result = true;
        } else if (type == EntityType.f_20549_ || type == EntityType.f_20550_ || type == EntityType.f_20551_ || type == EntityType.f_20509_ || type == EntityType.f_20453_ || type == EntityType.f_217014_ || type == EntityType.f_20491_ || type == EntityType.f_20496_) {
            result = true;
        }
        flyingEntityCache.put(mobClass, result);
        return result;
    }
}

