/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.network.NetworkEvent;

public class MountControlPacket {
    private final boolean jumping;
    private final boolean descending;
    private final float forward;
    private final float strafe;
    private final boolean sprinting;

    public MountControlPacket(boolean jumping, boolean descending, float forward, float strafe, boolean sprinting) {
        this.jumping = jumping;
        this.descending = descending;
        this.forward = forward;
        this.strafe = strafe;
        this.sprinting = sprinting;
    }

    public static void encode(MountControlPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.jumping);
        buf.writeBoolean(packet.descending);
        buf.writeFloat(packet.forward);
        buf.writeFloat(packet.strafe);
        buf.writeBoolean(packet.sprinting);
    }

    public static MountControlPacket decode(FriendlyByteBuf buf) {
        return new MountControlPacket(buf.readBoolean(), buf.readBoolean(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
    }

    public static void handle(MountControlPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity vehicle;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.m_20159_() && (vehicle = player.m_20202_()) instanceof Mob) {
                player.getPersistentData().m_128379_("mounting_jumping", packet.jumping);
                player.getPersistentData().m_128379_("mounting_descending", packet.descending);
                player.getPersistentData().m_128350_("mounting_forward", packet.forward);
                player.getPersistentData().m_128350_("mounting_strafe", packet.strafe);
                player.getPersistentData().m_128379_("mounting_sprinting", packet.sprinting);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

