/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.rideeverything.network;

import com.prizowo.rideeverything.entity.BlockSeatEntity;
import com.prizowo.rideeverything.init.ModEntities;
import com.prizowo.rideeverything.network.NetworkHandler;
import com.prizowo.rideeverything.network.RideConfirmPacket;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RidePacket {
    private final BlockPos pos;
    private final int entityId;
    private final boolean isMount;
    private final boolean isEntityInteraction;

    public RidePacket(BlockPos pos) {
        this.pos = pos;
        this.entityId = -1;
        this.isMount = false;
        this.isEntityInteraction = false;
    }

    public RidePacket(int entityId, boolean isMount) {
        this.entityId = entityId;
        this.isMount = isMount;
        this.pos = null;
        this.isEntityInteraction = true;
    }

    public static void encode(RidePacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isEntityInteraction);
        if (msg.isEntityInteraction) {
            buf.writeInt(msg.entityId);
            buf.writeBoolean(msg.isMount);
        } else {
            buf.m_130064_(msg.pos);
        }
    }

    public static RidePacket decode(FriendlyByteBuf buf) {
        boolean isEntityInteraction = buf.readBoolean();
        if (isEntityInteraction) {
            int entityId = buf.readInt();
            boolean isMount = buf.readBoolean();
            return new RidePacket(entityId, isMount);
        }
        BlockPos pos = buf.m_130135_();
        return new RidePacket(pos);
    }

    public static void handle(RidePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                if (msg.isEntityInteraction) {
                    Entity target = level.m_6815_(msg.entityId);
                    if (target != null && !(target instanceof AbstractHorse)) {
                        if (msg.isMount) {
                            boolean success = player.m_7998_(target, true);
                            if (success) {
                                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new RideConfirmPacket(player.m_19879_(), msg.entityId, true));
                            }
                        } else if (player.m_20159_()) {
                            player.m_8127_();
                            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new RideConfirmPacket(player.m_19879_(), msg.entityId, false));
                        }
                    }
                } else {
                    if (RidePacket.hasSeatEntityAt((Level)level, msg.pos)) {
                        return;
                    }
                    if (!RidePacket.isEnoughSpaceAbove((Level)level, msg.pos)) {
                        return;
                    }
                    BlockState state = level.m_8055_(msg.pos);
                    RidePacket.createSeatAndRide(player, (Level)level, msg.pos, state);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean hasSeatEntityAt(Level level, BlockPos pos) {
        List entities = level.m_45933_(null, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)));
        for (Entity entity : entities) {
            if (!(entity instanceof BlockSeatEntity)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnoughSpaceAbove(Level level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        List entities = level.m_45933_(null, new AABB((double)abovePos.m_123341_(), (double)abovePos.m_123342_(), (double)abovePos.m_123343_(), (double)(abovePos.m_123341_() + 1), (double)(abovePos.m_123342_() + 1), (double)(abovePos.m_123343_() + 1)));
        if (!entities.isEmpty()) {
            return false;
        }
        BlockState aboveState = level.m_8055_(abovePos);
        return aboveState.m_60795_() || !aboveState.m_60815_();
    }

    private static void createSeatAndRide(ServerPlayer player, Level level, BlockPos pos, BlockState state) {
        BlockSeatEntity seat = new BlockSeatEntity((EntityType)ModEntities.BLOCK_SEAT.get(), level);
        seat.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)seat);
        player.m_7998_((Entity)seat, true);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RideConfirmPacket(pos));
    }
}

