/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.debugoptions.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.nottouchedgrass.debugoptions.DebugOptions;
import com.nottouchedgrass.debugoptions.client.DebugOptionsCommand;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;

@Environment(value=EnvType.CLIENT)
public class DebugOptionsClient
implements ClientModInitializer {
    public static Map<String, String> debugMap = new HashMap<String, String>();
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("debugoptions.json");
    public static final Gson GSON = new Gson();
    public static final Map<String, Boolean> CHANGED_FLAGS = new HashMap<String, Boolean>();
    public static final Map<String, Boolean> DEFAULT_FLAGS = new HashMap<String, Boolean>();

    public void onInitializeClient() {
        debugMap.put("DEBUG_ENABLED", "field_62776");
        debugMap.put("DEBUG_OPEN_INCOMPATIBLE_WORLDS", "field_35006");
        debugMap.put("DEBUG_ALLOW_LOW_SIM_DISTANCE", "field_35563");
        debugMap.put("DEBUG_HOTKEYS", "field_29748");
        debugMap.put("DEBUG_UI_NARRATION", "field_33753");
        debugMap.put("DEBUG_SHUFFLE_UI_RENDERING_ORDER", "field_59991");
        debugMap.put("DEBUG_SHUFFLE_MODELS", "field_61885");
        debugMap.put("DEBUG_RENDER_UI_LAYERING_RECTANGLES", "field_60328");
        debugMap.put("DEBUG_PATHFINDING", "field_29750");
        debugMap.put("DEBUG_WATER", "field_29751");
        debugMap.put("DEBUG_HEIGHTMAP", "field_29752");
        debugMap.put("DEBUG_COLLISION", "field_29753");
        debugMap.put("DEBUG_SHOW_LOCAL_SERVER_ENTITY_HIT_BOXES", "field_52311");
        debugMap.put("DEBUG_SUPPORT_BLOCKS", "field_44779");
        debugMap.put("DEBUG_SHAPES", "field_29754");
        debugMap.put("DEBUG_NEIGHBORSUPDATE", "field_29755");
        debugMap.put("DEBUG_EXPERIMENTAL_REDSTONEWIRE_UPDATE_ORDER", "field_52319");
        debugMap.put("DEBUG_STRUCTURES", "field_29756");
        debugMap.put("DEBUG_LIGHT", "field_29676");
        debugMap.put("DEBUG_SKY_LIGHT_SECTIONS", "field_44582");
        debugMap.put("DEBUG_SOLID_FACE", "field_29678");
        debugMap.put("DEBUG_CHUNKS", "field_29679");
        debugMap.put("DEBUG_GAME_EVENT_LISTENERS", "field_29680");
        debugMap.put("DEBUG_DUMP_TEXTURE_ATLAS", "field_29681");
        debugMap.put("DEBUG_DUMP_INTERPOLATED_TEXTURE_FRAMES", "field_29682");
        debugMap.put("DEBUG_STRUCTURE_EDIT_MODE", "field_29683");
        debugMap.put("DEBUG_SAVE_STRUCTURES_AS_SNBT", "field_29684");
        debugMap.put("DEBUG_SYNCHRONOUS_GL_LOGS", "field_29685");
        debugMap.put("DEBUG_VERBOSE_SERVER_EVENTS", "field_29686");
        debugMap.put("DEBUG_NAMED_RUNNABLES", "field_29687");
        debugMap.put("DEBUG_GOAL_SELECTOR", "field_29688");
        debugMap.put("DEBUG_VILLAGE_SECTIONS", "field_29689");
        debugMap.put("DEBUG_BRAIN", "field_29690");
        debugMap.put("DEBUG_POI", "field_62771");
        debugMap.put("DEBUG_BEES", "field_29691");
        debugMap.put("DEBUG_RAIDS", "field_29692");
        debugMap.put("DEBUG_BLOCK_BREAK", "field_29693");
        debugMap.put("DEBUG_MONITOR_TICK_TIMES", "field_29695");
        debugMap.put("DEBUG_KEEP_JIGSAW_BLOCKS_DURING_STRUCTURE_GEN", "field_29696");
        debugMap.put("DEBUG_DONT_SAVE_WORLD", "field_29697");
        debugMap.put("DEBUG_LARGE_DRIPSTONE", "field_29698");
        debugMap.put("DEBUG_CARVERS", "field_29700");
        debugMap.put("DEBUG_ORE_VEINS", "field_33554");
        debugMap.put("DEBUG_SCULK_CATALYST", "field_37273");
        debugMap.put("DEBUG_BYPASS_REALMS_VERSION_CHECK", "field_39090");
        debugMap.put("DEBUG_SOCIAL_INTERACTIONS", "field_39460");
        debugMap.put("DEBUG_VALIDATE_RESOURCE_PATH_CASE", "field_39962");
        debugMap.put("DEBUG_UNLOCK_ALL_TRADES", "field_46154");
        debugMap.put("DEBUG_BREEZE_MOB", "field_47176");
        debugMap.put("DEBUG_TRIAL_SPAWNER_DETECTS_SHEEP_AS_PLAYERS", "field_47177");
        debugMap.put("DEBUG_VAULT_DETECTS_SHEEP_AS_PLAYERS", "field_48778");
        debugMap.put("DEBUG_FORCE_ONBOARDING_SCREEN", "field_47178");
        debugMap.put("DEBUG_CURSOR_POS", "field_58199");
        debugMap.put("DEBUG_DEFAULT_SKIN_OVERRIDE", "field_60521");
        debugMap.put("DEBUG_PANORAMA_SCREENSHOT", "field_62772");
        debugMap.put("DEBUG_CHASE_COMMAND", "field_62773");
        debugMap.put("DEBUG_IGNORE_LOCAL_MOB_CAP", "field_34368");
        debugMap.put("DEBUG_DISABLE_LIQUID_SPREADING", "field_29710");
        debugMap.put("DEBUG_AQUIFERS", "field_34369");
        debugMap.put("DEBUG_JFR_PROFILING_ENABLE_LEVEL_LOADING", "field_34370");
        debugMap.put("DEBUG_ENTITY_BLOCK_INTERSECTION", "field_60959");
        debugMap.put("debugGenerateSquareTerrainWithoutNoise", "field_34371");
        debugMap.put("DEBUG_ONLY_GENERATE_HALF_THE_WORLD", "field_29711");
        debugMap.put("DEBUG_DISABLE_FLUID_GENERATION", "field_29712");
        debugMap.put("DEBUG_DISABLE_AQUIFERS", "field_29713");
        debugMap.put("DEBUG_DISABLE_SURFACE", "field_29715");
        debugMap.put("DEBUG_DISABLE_CARVERS", "field_29716");
        debugMap.put("DEBUG_DISABLE_STRUCTURES", "field_29717");
        debugMap.put("DEBUG_DISABLE_FEATURES", "field_29718");
        debugMap.put("DEBUG_DISABLE_ORE_VEINS", "field_33555");
        debugMap.put("DEBUG_DISABLE_BLENDING", "field_35438");
        debugMap.put("DEBUG_DISABLE_BELOW_ZERO_RETROGENERATION", "field_35439");
        debugMap.put("DEBUG_SUBTITLES", "field_29721");
        boolean isDevNamed = FabricLoader.getInstance().isDevelopmentEnvironment();
        if (isDevNamed) {
            DebugOptions.LOGGER.info("Developer environment! Using official mappings!");
        } else {
            DebugOptions.LOGGER.info("Using intermediate names...");
        }
        if (isDevNamed) {
            for (Map.Entry entry : debugMap.entrySet()) {
                entry.setValue((String)entry.getKey());
            }
        }
        for (String string : debugMap.values()) {
            try {
                DEFAULT_FLAGS.put(string, class_155.class.getDeclaredField(string).getBoolean(null));
            }
            catch (Exception exception) {}
        }
        DebugOptionsClient.loadConfig();
        DebugOptionsClient.applyConfig();
        DebugOptionsCommand.register();
    }

    public static void loadConfig() {
        if (CONFIG_FILE.toFile().exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
                Map map = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Boolean>>(){}.getType());
                if (map != null) {
                    CHANGED_FLAGS.putAll(map);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
            GSON.toJson(CHANGED_FLAGS, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void applyConfig() {
        CHANGED_FLAGS.forEach((fieldName, value) -> {
            try {
                Field f = class_155.class.getDeclaredField((String)fieldName);
                f.setAccessible(true);
                if (f.getType() == Boolean.TYPE) {
                    f.setBoolean(null, (boolean)value);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        });
    }
}

