/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.debugoptions.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.nottouchedgrass.debugoptions.client.DebugOptionsClient;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DebugOptionsCommand {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debugoptions").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"field", (ArgumentType)StringArgumentType.word()).suggests(DebugOptionsCommand::suggestDebugFields).executes(DebugOptionsCommand::printValue)).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            builder.suggest("true");
            builder.suggest("false");
            builder.suggest("reset");
            return builder.buildFuture();
        }).executes(DebugOptionsCommand::setOrResetValue)))));
    }

    private static CompletableFuture<Suggestions> suggestDebugFields(CommandContext<FabricClientCommandSource> fabricClientCommandSourceCommandContext, SuggestionsBuilder builder) {
        String prefix = builder.getRemaining().toUpperCase();
        DebugOptionsClient.debugMap.keySet().stream().filter(name -> name.toUpperCase().contains(prefix)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int printValue(CommandContext<?> ctx) {
        String fieldName = StringArgumentType.getString(ctx, (String)"field");
        try {
            fieldName = DebugOptionsClient.debugMap.get(fieldName);
            Field f = class_155.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            if (f.getType() != Boolean.TYPE) {
                DebugOptionsCommand.send("Field " + fieldName + " is not a boolean!");
                return 0;
            }
            boolean value = f.getBoolean(null);
            DebugOptionsCommand.send(fieldName + " = " + value + (DebugOptionsClient.CHANGED_FLAGS.containsKey(fieldName) ? " (Changed!)" : ""));
            return 1;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            DebugOptionsCommand.send("Cannot access field " + fieldName + ": " + e.getMessage());
            return 0;
        }
    }

    private static int setOrResetValue(CommandContext<?> ctx) {
        String fieldName = StringArgumentType.getString(ctx, (String)"field");
        String valueStr = StringArgumentType.getString(ctx, (String)"value").toLowerCase();
        if (!DebugOptionsClient.debugMap.keySet().contains(fieldName)) {
            DebugOptionsCommand.send(fieldName + " is invalid debug option!");
            return 0;
        }
        try {
            fieldName = DebugOptionsClient.debugMap.get(fieldName);
            Field f = class_155.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            if (f.getType() != Boolean.TYPE) {
                DebugOptionsCommand.send("Field " + fieldName + " is not a boolean!");
                return 0;
            }
            if (valueStr.equals("reset")) {
                boolean defaultValue = DebugOptionsClient.DEFAULT_FLAGS.getOrDefault(fieldName, f.getBoolean(null));
                f.setBoolean(null, defaultValue);
                DebugOptionsClient.CHANGED_FLAGS.remove(fieldName);
                DebugOptionsClient.saveConfig();
                DebugOptionsCommand.send("Reset " + fieldName + " to default (" + defaultValue + ")");
                return 1;
            }
            boolean newValue = Boolean.parseBoolean(valueStr);
            f.setBoolean(null, newValue);
            DebugOptionsClient.CHANGED_FLAGS.put(fieldName, newValue);
            DebugOptionsClient.saveConfig();
            DebugOptionsCommand.send("Set " + fieldName + " = " + newValue + (!class_155.field_62776 && newValue && !fieldName.equals("DEBUG_ENABLED") ? " (DEBUG_ENABLED is disabled!)" : ""));
            return 1;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            DebugOptionsCommand.send("Cannot access field " + fieldName + ": " + e.getMessage());
            return 0;
        }
    }

    private static void send(String msg) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("[DebugOptions] " + msg)), false);
        }
    }
}

