/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.debugoptions.client;

import com.nottouchedgrass.debugoptions.client.DebugOptionsClient;
import java.lang.reflect.Field;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class DebugOptionsScreen
extends class_437 {
    public class_342 searchBox;
    public DebugList debugListWidget;
    public class_4286 onlyChanged;
    public class_4286 debugEnabled;
    public class_437 lastScreen;

    public DebugOptionsScreen(class_437 screen) {
        super((class_2561)class_2561.method_43470((String)"Debug Options"));
        this.lastScreen = screen;
    }

    protected void method_25426() {
        this.onlyChanged = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Only changed"), (class_327)class_310.method_1551().field_1772).method_54794(false).method_54791((box, newValue) -> this.refreshList()).method_54789(this.field_22789 / 2 + 10, 21).method_54788();
        this.method_37063((class_364)this.onlyChanged);
        this.debugEnabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)"DEBUG_ENABLED"), (class_327)class_310.method_1551().field_1772).method_54794(class_155.field_62776).method_54791((box, newValue) -> {
            class_155.field_62776 = newValue;
        }).method_54789(this.field_22789 / 2 + 110, 21).method_54793(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Most options will not work without it!"))).method_54788();
        this.method_37063((class_364)this.debugEnabled);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 200, 20, 200, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1863(s -> this.refreshList());
        this.method_37063((class_364)this.searchBox);
        this.debugListWidget = new DebugList(this.field_22787, this.field_22789, this.field_22790 - 90, 50, 20);
        this.method_37063((class_364)this.debugListWidget);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.method_25419()).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 25, 100, 20).method_46431());
        this.refreshList();
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.lastScreen);
    }

    private void refreshList() {
        String filter = this.searchBox.method_1882().toLowerCase();
        List<String> filtered = DebugOptionsClient.debugMap.keySet().stream().filter(name -> name.toLowerCase().contains(filter)).filter(name -> !this.onlyChanged.field_19230 || DebugOptionsClient.CHANGED_FLAGS.containsKey(DebugOptionsClient.debugMap.get(name))).filter(name -> !name.equals("DEBUG_ENABLED")).toList();
        this.debugListWidget.method_25339();
        for (String name2 : filtered) {
            this.debugListWidget.method_25321((class_350.class_351)new DebugEntry(this.debugListWidget, name2));
        }
        if (!this.debugListWidget.method_25396().isEmpty()) {
            int totalHeight = this.debugListWidget.method_25396().size() * ((DebugEntry)((Object)this.debugListWidget.method_25396().getFirst())).method_25364();
            if (this.debugListWidget.method_44387() > (double)totalHeight) {
                this.debugListWidget.method_44382(totalHeight);
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, (class_2561)((class_5250)this.field_22785).method_27692(class_124.field_1068), this.field_22789 / 2, 6, -12566464);
    }

    @Environment(value=EnvType.CLIENT)
    private static class DebugList
    extends class_4280<DebugEntry> {
        public DebugList(class_310 mc, int width, int height, int top, int bottom) {
            super(mc, width, height, top, bottom);
        }

        public int method_25322() {
            return (int)((double)this.field_22758 * 0.8);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class DebugEntry
    extends class_4280.class_4281<DebugEntry> {
        private final String fieldName;
        private final class_4286 checkbox;
        private final class_4185 resetButton;

        public DebugEntry(DebugList parent, String fieldName) {
            this.fieldName = fieldName;
            boolean currentValue = DebugEntry.getValue(fieldName);
            this.checkbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)fieldName), (class_327)class_310.method_1551().field_1772).method_54794(currentValue).method_54791((box, newValue) -> DebugEntry.setValue(fieldName, newValue)).method_54788();
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), btn -> {
                boolean defaultValue = DebugOptionsClient.DEFAULT_FLAGS.getOrDefault(DebugOptionsClient.debugMap.get(fieldName), DebugEntry.getValue(fieldName));
                DebugEntry.setValue(fieldName, defaultValue);
                DebugOptionsClient.CHANGED_FLAGS.remove(DebugOptionsClient.debugMap.get(fieldName));
                DebugOptionsClient.saveConfig();
                this.checkbox.field_19230 = defaultValue;
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof DebugOptionsScreen) {
                    DebugOptionsScreen debugOptionsScreen = (DebugOptionsScreen)patt0$temp;
                    if (debugOptionsScreen.onlyChanged.method_20372()) {
                        debugOptionsScreen.refreshList();
                    }
                }
            }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Resets value to Minecraft default instead of loading from config"))).method_46434(0, 0, 50, 20).method_46431();
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
            int left = this.method_73380();
            int top = this.method_73382();
            this.checkbox.method_46421(left + 4);
            this.checkbox.method_46419(top);
            this.checkbox.method_25394(guiGraphics, mouseX, mouseY, delta);
            this.resetButton.method_46421(this.method_73389() - 50);
            this.resetButton.method_46419(top - 1);
            this.resetButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        }

        public List<? extends class_339> children() {
            return List.of(this.checkbox, this.resetButton);
        }

        public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
            if (this.resetButton.method_25402(mouseButtonEvent, bl)) {
                return true;
            }
            return this.checkbox.method_25402(mouseButtonEvent, bl);
        }

        public boolean method_25406(class_11909 mouseButtonEvent) {
            if (this.checkbox.method_25406(mouseButtonEvent)) {
                return true;
            }
            return this.resetButton.method_25406(mouseButtonEvent);
        }

        public boolean method_25403(class_11909 mouseButtonEvent, double d, double e) {
            if (this.checkbox.method_25403(mouseButtonEvent, d, e)) {
                return true;
            }
            return this.resetButton.method_25403(mouseButtonEvent, d, e);
        }

        public boolean method_25404(class_11908 keyEvent) {
            return this.checkbox.method_25404(keyEvent);
        }

        public boolean method_25400(class_11905 charEvent) {
            return this.checkbox.method_25400(charEvent);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.fieldName);
        }

        private static boolean getValue(String fieldName) {
            try {
                Field f = class_155.class.getDeclaredField(DebugOptionsClient.debugMap.get(fieldName));
                f.setAccessible(true);
                return f.getBoolean(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private static void setValue(String fieldName, boolean newValue) {
            try {
                Field f = class_155.class.getDeclaredField(DebugOptionsClient.debugMap.get(fieldName));
                f.setAccessible(true);
                f.setBoolean(null, newValue);
                DebugOptionsClient.CHANGED_FLAGS.put(DebugOptionsClient.debugMap.get(fieldName), newValue);
                DebugOptionsClient.saveConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

