/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage;

import com.portable.storage.block.ModBlocks;
import com.portable.storage.blockentity.ModBlockEntities;
import com.portable.storage.command.BarrelCommands;
import com.portable.storage.command.NewStoreCommands;
import com.portable.storage.command.SpaceRiftCommands;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.entity.ModEntities;
import com.portable.storage.event.EnchantedGoldenAppleHandler;
import com.portable.storage.event.IncrementalSyncTickHandler;
import com.portable.storage.event.PistonBlockRotationHandler;
import com.portable.storage.event.PistonUpgradeHandler;
import com.portable.storage.event.PlayerDeathEventHandler;
import com.portable.storage.event.PlayerInteractEventHandler;
import com.portable.storage.event.PlayerJoinEventHandler;
import com.portable.storage.event.SpaceRiftEvents;
import com.portable.storage.event.SpaceRiftProtectionEvents;
import com.portable.storage.event.StorageKeyAutoUseHandler;
import com.portable.storage.event.TempBedEventHandler;
import com.portable.storage.event.XpMaintenanceEventHandler;
import com.portable.storage.item.ModItems;
import com.portable.storage.net.NetworkChannels;
import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.newstore.StorageMemoryCache;
import com.portable.storage.screen.PortableCraftingScreenHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableStorage
implements ModInitializer {
    public static final String MOD_ID = "portable-storage";
    public static class_3917<PortableCraftingScreenHandler> PORTABLE_CRAFTING_HANDLER;
    public static final class_1792 STORAGE_KEY_ITEM;
    public static final Logger LOGGER;

    public void onInitialize() {
        ServerConfig.getInstance().load();
        ModBlocks.register();
        ModBlockEntities.register();
        ModItems.register();
        NetworkChannels.registerCodecs();
        PORTABLE_CRAFTING_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"portable_crafting"), (Object)new class_3917(PortableCraftingScreenHandler::new, class_7699.method_45397()));
        ServerNetworkingHandlers.register();
        PlayerInteractEventHandler.register();
        PlayerJoinEventHandler.register();
        PlayerDeathEventHandler.register();
        TempBedEventHandler.register();
        XpMaintenanceEventHandler.register();
        SpaceRiftEvents.register();
        SpaceRiftProtectionEvents.register();
        ModEntities.register();
        SpaceRiftCommands.register();
        NewStoreCommands.register();
        BarrelCommands.register();
        IncrementalSyncTickHandler.register();
        StorageKeyAutoUseHandler.register();
        PistonUpgradeHandler.register();
        PistonBlockRotationHandler.register();
        EnchantedGoldenAppleHandler.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> StorageMemoryCache.initialize(server));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> StorageMemoryCache.shutdown());
        LOGGER.info("Portable Storage initialized");
    }

    static {
        STORAGE_KEY_ITEM = ModItems.STORAGE_KEY;
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

