/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage;

import com.portable.storage.PortableStorage;
import com.portable.storage.client.ClientConfig;
import com.portable.storage.client.ClientNetworkingHandlers;
import com.portable.storage.client.ModernUiCompat;
import com.portable.storage.client.event.ScreenEventHandler;
import com.portable.storage.client.screen.PortableCraftingScreen;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.entity.ModEntities;
import com.portable.storage.entity.RiftAvatarEntity;
import com.portable.storage.item.StorageKeyItem;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_897;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class PortableStorageClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientConfig.load();
        ClientNetworkingHandlers.register();
        ScreenEventHandler.register();
        class_3929.method_17542(PortableStorage.PORTABLE_CRAFTING_HANDLER, PortableCraftingScreen::new);
        try {
            EntityRendererRegistry.register(ModEntities.RIFT_AVATAR, ctx -> new class_897<RiftAvatarEntity>(this, ctx){

                public class_2960 getTexture(RiftAvatarEntity entity) {
                    return class_2960.method_60655((String)"minecraft", (String)"textures/entity/steve.png");
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ModernUiCompat.isLoaded()) {
            ClientTickEvents.END_CLIENT_TICK.register(client -> ModernUiCompat.forceTooltipShadowRadiusZero());
        }
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            try {
                class_2487 nbt;
                class_9279 comp;
                if (stack != null && stack.method_7909() == class_1802.field_16307 && (comp = (class_9279)stack.method_57824(class_9334.field_49628)) != null && (nbt = comp.method_57461()).method_10545("ps_owner_uuid_most") && nbt.method_10545("ps_owner_uuid_least")) {
                    String name = nbt.method_10545("ps_owner_name") ? nbt.method_10558("ps_owner_name") : "?";
                    UUID uuid = new UUID(nbt.method_10537("ps_owner_uuid_most"), nbt.method_10537("ps_owner_uuid_least"));
                    lines.add(class_2561.method_43469((String)"portable-storage.tooltip.bound_to", (Object[])new Object[]{name, uuid.toString()}).method_27692(class_124.field_1080));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            try {
                if (stack != null && stack.method_7909() == PortableStorage.STORAGE_KEY_ITEM) {
                    class_2561 boundText = StorageKeyItem.getBoundTooltip(stack);
                    if (boundText != null) {
                        lines.add(boundText);
                    }
                    lines.add(class_2561.method_43471((String)"portable-storage.tooltip.storage_key_usage").method_27692(class_124.field_1080));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            try {
                String[] parts;
                String enableItem;
                if (stack != null && (enableItem = ServerConfig.getInstance().getEnableItem()) != null && !enableItem.isEmpty() && (parts = enableItem.split(":")).length == 2) {
                    String namespace = parts[0];
                    String itemId = parts[1];
                    if (stack.method_7909().toString().equals(namespace + ":" + itemId)) {
                        lines.add(class_2561.method_43471((String)"portable-storage.tooltip.enable_item_usage").method_27692(class_124.field_1065));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

